/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package es.upv.dsic.issi.dplfw.dfm.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import es.upv.dsic.issi.dplfw.dfm.util.DfmAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class DfmItemProviderAdapterFactory extends DfmAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DfmItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentFeatureModelItemProvider documentFeatureModelItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDocumentFeatureModelAdapter() {
		if (documentFeatureModelItemProvider == null) {
			documentFeatureModelItemProvider = new DocumentFeatureModelItemProvider(this);
		}

		return documentFeatureModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ContentDocumentFeatureItemProvider contentDocumentFeatureItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createContentDocumentFeatureAdapter() {
		if (contentDocumentFeatureItemProvider == null) {
			contentDocumentFeatureItemProvider = new ContentDocumentFeatureItemProvider(this);
		}

		return contentDocumentFeatureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TechnologyDocumentFeatureItemProvider technologyDocumentFeatureItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfm.TechnologyDocumentFeature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTechnologyDocumentFeatureAdapter() {
		if (technologyDocumentFeatureItemProvider == null) {
			technologyDocumentFeatureItemProvider = new TechnologyDocumentFeatureItemProvider(this);
		}

		return technologyDocumentFeatureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfm.Annotation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AnnotationItemProvider annotationItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfm.Annotation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnnotationAdapter() {
		if (annotationItemProvider == null) {
			annotationItemProvider = new AnnotationItemProvider(this);
		}

		return annotationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfm.AnnotationEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AnnotationEntryItemProvider annotationEntryItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfm.AnnotationEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnnotationEntryAdapter() {
		if (annotationEntryItemProvider == null) {
			annotationEntryItemProvider = new AnnotationEntryItemProvider(this);
		}

		return annotationEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfm.RequiresFeature} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RequiresFeatureItemProvider requiresFeatureItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfm.RequiresFeature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRequiresFeatureAdapter() {
		if (requiresFeatureItemProvider == null) {
			requiresFeatureItemProvider = new RequiresFeatureItemProvider(this);
		}

		return requiresFeatureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfm.ExcludesFeature} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExcludesFeatureItemProvider excludesFeatureItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfm.ExcludesFeature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExcludesFeatureAdapter() {
		if (excludesFeatureItemProvider == null) {
			excludesFeatureItemProvider = new ExcludesFeatureItemProvider(this);
		}

		return excludesFeatureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfm.DocumentContext} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentContextItemProvider documentContextItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfm.DocumentContext}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDocumentContextAdapter() {
		if (documentContextItemProvider == null) {
			documentContextItemProvider = new DocumentContextItemProvider(this);
		}

		return documentContextItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfm.Reference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReferenceItemProvider referenceItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfm.Reference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReferenceAdapter() {
		if (referenceItemProvider == null) {
			referenceItemProvider = new ReferenceItemProvider(this);
		}

		return referenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfm.VariableAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableAttributeItemProvider variableAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfm.VariableAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableAttributeAdapter() {
		if (variableAttributeItemProvider == null) {
			variableAttributeItemProvider = new VariableAttributeItemProvider(this);
		}

		return variableAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfm.CriterionAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CriterionAttributeItemProvider criterionAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfm.CriterionAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCriterionAttributeAdapter() {
		if (criterionAttributeItemProvider == null) {
			criterionAttributeItemProvider = new CriterionAttributeItemProvider(this);
		}

		return criterionAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link es.upv.dsic.issi.dplfw.dfm.Criterion} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CriterionItemProvider criterionItemProvider;

	/**
	 * This creates an adapter for a {@link es.upv.dsic.issi.dplfw.dfm.Criterion}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCriterionAdapter() {
		if (criterionItemProvider == null) {
			criterionItemProvider = new CriterionItemProvider(this);
		}

		return criterionItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (documentFeatureModelItemProvider != null) documentFeatureModelItemProvider.dispose();
		if (contentDocumentFeatureItemProvider != null) contentDocumentFeatureItemProvider.dispose();
		if (technologyDocumentFeatureItemProvider != null) technologyDocumentFeatureItemProvider.dispose();
		if (annotationItemProvider != null) annotationItemProvider.dispose();
		if (annotationEntryItemProvider != null) annotationEntryItemProvider.dispose();
		if (requiresFeatureItemProvider != null) requiresFeatureItemProvider.dispose();
		if (excludesFeatureItemProvider != null) excludesFeatureItemProvider.dispose();
		if (documentContextItemProvider != null) documentContextItemProvider.dispose();
		if (referenceItemProvider != null) referenceItemProvider.dispose();
		if (variableAttributeItemProvider != null) variableAttributeItemProvider.dispose();
		if (criterionAttributeItemProvider != null) criterionAttributeItemProvider.dispose();
		if (criterionItemProvider != null) criterionItemProvider.dispose();
	}

}
