/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZIPUtil {
    public static void unzip(InputStream inputStream, File outputDirectory) throws IOException {
        ZIPUtil.unzip(new ZipInputStream(inputStream), outputDirectory, true);
    }

    public static void unzip(ZipInputStream zipInputStream, File outputDirectory) throws IOException {
        ZIPUtil.unzip(zipInputStream, outputDirectory, true);
    }

    public static void unzip(InputStream inputStream, File outputDirectory, boolean overwrite) throws IOException {
        ZIPUtil.unzip(new ZipInputStream(inputStream), outputDirectory, overwrite);
    }

    public static void unzip(ZipInputStream zipInputStream, File outputDirectory, boolean overwrite) throws IOException {
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        ZipEntry entry = zipInputStream.getNextEntry();
        while (entry != null) {
            String fileName = entry.getName();
            File newFile = new File(String.valueOf(outputDirectory.getAbsolutePath()) + File.separator + fileName);
            if (entry.isDirectory()) {
                newFile.mkdirs();
            } else if (!newFile.exists() || overwrite) {
                int len;
                if (!newFile.getParentFile().exists()) {
                    newFile.getParentFile().mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(newFile);
                byte[] buffer = new byte[1024];
                while ((len = zipInputStream.read(buffer)) > 0) {
                    fileOutputStream.write(buffer, 0, len);
                }
                fileOutputStream.close();
            }
            entry = zipInputStream.getNextEntry();
        }
    }
}

