/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.nature;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.internal.DplProject;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class DplNature
implements IProjectNature {
    private IProject project;

    public void configure() throws CoreException {
        this.registerBuilder();
        DplProject dplProject = new DplProject(this.project);
        dplProject.initializePreferences();
    }

    public void deconfigure() throws CoreException {
        this.unregisterBuilder();
    }

    protected void registerBuilder() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(DplfwPlugin.BUILDER_ID)) {
                return;
            }
            ++i;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName(DplfwPlugin.BUILDER_ID);
        newCommands[newCommands.length - 1] = command;
        desc.setBuildSpec(newCommands);
        this.project.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void unregisterBuilder() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(DplfwPlugin.BUILDER_ID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                return;
            }
            ++i;
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static void addDplNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(String.format("Adding DPL nature to \"%s\" project", project.getName()), 2);
            if (!project.hasNature(DplfwPlugin.NATURE_ID)) {
                IProjectDescription description = project.getDescription();
                String[] prevNatures = description.getNatureIds();
                String[] newNatures = new String[prevNatures.length + 1];
                System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
                newNatures[prevNatures.length] = DplfwPlugin.NATURE_ID;
                description.setNatureIds(newNatures);
                monitor.worked(1);
                project.setDescription(description, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            }
        }
        finally {
            monitor.done();
        }
    }
}

