/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.model.internal;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDfmConfFile;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.model.internal.DfmConfFile;
import es.upv.dsic.issi.dplfw.core.model.internal.DfmFile;
import es.upv.dsic.issi.dplfw.core.model.internal.DplFolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class DplProject
implements IDplProject {
    private static String DFM_FOLDER = "dfm.folder";
    private static String DFMCONF_FOLDERS = "dfmconf.folders";
    private static String WFM_FOLDERS = "wfm.folders";
    private static String RESOURCES_FOLDER = "resources.folder";
    private static String OUT_FOLDER = "out.folder";
    private static String DFM_FILE = "dfm.file";
    private static String DEFAULT_DFM_FOLDER = "model";
    private static String DEFAULT_DFMCONF_FOLDER = "configurations";
    private static String DEFAULT_WFM_FOLDER = "workflows";
    private static String DEFAULT_RESOURCES_FOLDER = "resources";
    private static String DEFAULT_OUT_FOLDER = "out";
    private static String DEFAUL_DFM_FILE = String.valueOf(DEFAULT_DFM_FOLDER) + "model." + "dfm";
    private IProject project;

    public DplProject(IProject project) {
        this.project = project;
        this.ensureFoldersExist();
    }

    public void initializePreferences() {
        IEclipsePreferences preferences = this.getEclipsePreferences();
        preferences.put(DFM_FOLDER, DEFAULT_DFM_FOLDER);
        preferences.put(DFMCONF_FOLDERS, DEFAULT_DFMCONF_FOLDER);
        preferences.put(WFM_FOLDERS, DEFAULT_WFM_FOLDER);
        preferences.put(RESOURCES_FOLDER, DEFAULT_RESOURCES_FOLDER);
        preferences.put(OUT_FOLDER, DEFAULT_OUT_FOLDER);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            DplfwPlugin.log((Exception)((Object)e));
        }
    }

    @Override
    public IDfmFile initializeDfm(String dfmFileName, IProgressMonitor monitor) throws CoreException, IOException {
        DfmFile dfmFile = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("Initializing Document Feature Model", 3);
            IEclipsePreferences preferences = this.getEclipsePreferences();
            String dfmFolderName = preferences.get(DFM_FOLDER, DEFAULT_DFM_FOLDER);
            IFolder dfmFolder = this.project.getFolder(dfmFolderName);
            if (!dfmFolder.exists()) {
                dfmFolder.create(true, false, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            } else {
                monitor.worked(1);
            }
            dfmFile = new DfmFile(dfmFolder.getFile(dfmFileName));
            dfmFile.initialize((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            this.setDfmFile(dfmFile);
        }
        finally {
            monitor.done();
        }
        return dfmFile;
    }

    protected synchronized void ensureFoldersExist() {
        ArrayList<IDplFolder> dplFolders = new ArrayList<IDplFolder>();
        dplFolders.add(this.getDfmFolder());
        dplFolders.addAll(this.getDfmconfFolders());
        dplFolders.addAll(this.getWfmFolders());
        dplFolders.add(this.getResourcesFolder());
        dplFolders.add(this.getOutputFolder());
        for (IDplFolder dplFolder : dplFolders) {
            if (dplFolder.getFolder().exists()) continue;
            try {
                dplFolder.getFolder().create(true, false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                DplfwPlugin.log((Exception)((Object)e));
            }
        }
    }

    public IEclipsePreferences getEclipsePreferences() {
        if (!DplProject.hasDplNature(this.project)) {
            return null;
        }
        ProjectScope context = new ProjectScope(this.getProject());
        IEclipsePreferences eclipsePreferences = context.getNode(DplfwPlugin.PLUGIN_ID);
        return eclipsePreferences;
    }

    protected static boolean hasDplNature(IProject project) {
        try {
            return project.hasNature(DplfwPlugin.NATURE_ID);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IDplFolder getDfmFolder() {
        String path = this.getEclipsePreferences().get(DFM_FOLDER, DEFAULT_DFM_FOLDER);
        return new DplFolder(this.project.getFolder(path));
    }

    @Override
    public void setDfmFolder(IDplFolder folder) {
        IEclipsePreferences eclipsePreferences = this.getEclipsePreferences();
        eclipsePreferences.put(DFM_FOLDER, folder.toString());
        try {
            eclipsePreferences.flush();
        }
        catch (BackingStoreException e) {
            DplfwPlugin.log((Exception)((Object)e));
        }
    }

    @Override
    public boolean isDfmFolder(IDplFolder folder) {
        return folder.equals(this.getDfmFolder());
    }

    @Override
    public IDfmFile getDfmFile() {
        String path = this.getEclipsePreferences().get(DFM_FILE, DEFAUL_DFM_FILE);
        return new DfmFile(this.project.getFile(path));
    }

    @Override
    public void setDfmFile(IDfmFile file) {
        IEclipsePreferences eclipsePreferences = this.getEclipsePreferences();
        eclipsePreferences.put(DFM_FILE, file.getFile().getProjectRelativePath().toString());
        try {
            eclipsePreferences.flush();
        }
        catch (BackingStoreException e) {
            DplfwPlugin.log((Exception)((Object)e));
        }
    }

    @Override
    public List<IDplFolder> getDfmconfFolders() {
        String[] folderNames;
        ArrayList<IDplFolder> folders = new ArrayList<IDplFolder>();
        IEclipsePreferences preferences = this.getEclipsePreferences();
        String value = preferences.get(DFMCONF_FOLDERS, DEFAULT_DFMCONF_FOLDER);
        String[] stringArray = folderNames = StringUtils.split((String)value, (String)",");
        int n = folderNames.length;
        int n2 = 0;
        while (n2 < n) {
            String folderName = stringArray[n2];
            folders.add(new DplFolder(this.project.getFolder(folderName)));
            ++n2;
        }
        return folders;
    }

    @Override
    public void setDfmconfFolders(List<IDplFolder> folders) {
        IEclipsePreferences eclipsePreferences = this.getEclipsePreferences();
        String string = StringUtils.join(folders, (String)",");
        eclipsePreferences.put(DFMCONF_FOLDERS, string);
        try {
            eclipsePreferences.flush();
        }
        catch (BackingStoreException e) {
            DplfwPlugin.log((Exception)((Object)e));
        }
    }

    @Override
    public boolean isDfmconfFolder(IDplFolder folder) {
        List<IDplFolder> dfmconfFolders = this.getDfmconfFolders();
        for (IDplFolder dplFolder : dfmconfFolders) {
            if (!folder.equals(dplFolder)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IDfmConfFile> findDfmConfFiles() throws CoreException {
        final ArrayList<IDfmConfFile> configurationFiles = new ArrayList<IDfmConfFile>();
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (IDplFile.isDfmConfFile(resource)) {
                    configurationFiles.add(new DfmConfFile((IFile)resource));
                }
                return true;
            }
        };
        this.project.accept(visitor);
        return configurationFiles;
    }

    @Override
    public List<IDfmConfFile> findDfmConfFilesFor(final IDfmFile dfmFile) throws CoreException {
        final ArrayList<IDfmConfFile> configurationFiles = new ArrayList<IDfmConfFile>();
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                DfmConfFile dfmConfFile;
                if (IDplFile.isDfmConfFile(resource) && (dfmConfFile = new DfmConfFile((IFile)resource)).getDfmFile().equals(dfmFile)) {
                    configurationFiles.add(dfmConfFile);
                }
                return true;
            }
        };
        this.project.accept(visitor);
        return configurationFiles;
    }

    @Override
    public List<IDplFolder> getWfmFolders() {
        String[] folderNames;
        ArrayList<IDplFolder> folders = new ArrayList<IDplFolder>();
        IEclipsePreferences preferences = this.getEclipsePreferences();
        String value = preferences.get(WFM_FOLDERS, DEFAULT_WFM_FOLDER);
        String[] stringArray = folderNames = StringUtils.split((String)value, (String)",");
        int n = folderNames.length;
        int n2 = 0;
        while (n2 < n) {
            String folderName = stringArray[n2];
            folders.add(new DplFolder(this.project.getFolder(folderName)));
            ++n2;
        }
        return folders;
    }

    @Override
    public void setWfmFolders(List<IDplFolder> folders) {
        IEclipsePreferences eclipsePreferences = this.getEclipsePreferences();
        String string = StringUtils.join(folders, (String)",");
        eclipsePreferences.put(WFM_FOLDERS, string);
        try {
            eclipsePreferences.flush();
        }
        catch (BackingStoreException e) {
            DplfwPlugin.log((Exception)((Object)e));
        }
    }

    @Override
    public boolean isWfmFolder(IDplFolder folder) {
        List<IDplFolder> wfmFolders = this.getWfmFolders();
        for (IDplFolder wfmFolder : wfmFolders) {
            if (!folder.equals(wfmFolder)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IDplFolder getResourcesFolder() {
        String path = this.getEclipsePreferences().get(RESOURCES_FOLDER, DEFAULT_RESOURCES_FOLDER);
        return new DplFolder(this.project.getFolder(path));
    }

    @Override
    public void setResourcesFolder(IDplFolder folder) {
        IEclipsePreferences eclipsePreferences = this.getEclipsePreferences();
        eclipsePreferences.put(RESOURCES_FOLDER, folder.toString());
        try {
            eclipsePreferences.flush();
        }
        catch (BackingStoreException e) {
            DplfwPlugin.log((Exception)((Object)e));
        }
    }

    @Override
    public boolean isResourcesFolder(IDplFolder folder) {
        return folder.equals(this.getResourcesFolder());
    }

    @Override
    public IDplFolder getOutputFolder() {
        String path = this.getEclipsePreferences().get(OUT_FOLDER, DEFAULT_OUT_FOLDER);
        return new DplFolder(this.project.getFolder(path));
    }

    @Override
    public void setOutputFolder(IDplFolder folder) {
        IEclipsePreferences eclipsePreferences = this.getEclipsePreferences();
        eclipsePreferences.put(OUT_FOLDER, folder.toString());
        try {
            eclipsePreferences.flush();
        }
        catch (BackingStoreException e) {
            DplfwPlugin.log((Exception)((Object)e));
        }
    }

    @Override
    public boolean isOuputFolder(IDplFolder folder) {
        return folder.equals(this.getOutputFolder());
    }

    public String toString() {
        return this.project.getName();
    }

    public boolean equals(Object obj) {
        if (this.project == null) {
            return false;
        }
        if (!(obj instanceof DplProject)) {
            return false;
        }
        IProject objProject = ((DplProject)obj).getProject();
        return this.project.equals((Object)objProject);
    }

    public int hashCode() {
        int hash = 33;
        return hash + this.project.hashCode();
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Platform.getAdapterManager().getAdapter((Object)this.project, adapter);
    }
}

