/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.model.internal;

import es.upv.dsic.issi.dplfw.core.model.IDplFile;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.model.internal.DplProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public abstract class DplFile
implements IDplFile {
    protected IFile file;

    public DplFile(IFile file) {
        this.file = file;
    }

    @Override
    public <T extends IDplFile> T as(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public IFile getFile() {
        return this.file;
    }

    @Override
    public boolean isSameFile(IFile file) {
        if (this.file != null && file != null) {
            return this.file.equals((Object)file);
        }
        return false;
    }

    protected static Resource createResource(IPath path) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(DplFile.getURI(path));
        return resource;
    }

    protected static Resource getResource(IPath path) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(DplFile.getURI(path), true);
        return resource;
    }

    protected static URI getURI(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    @Override
    public URI getURI() {
        return DplFile.getURI(this.file.getFullPath());
    }

    @Override
    public String getFullPathString() {
        return this.file.getFullPath().toString();
    }

    public String toString() {
        return this.file.getProjectRelativePath().toString();
    }

    public boolean equals(Object obj) {
        if (this.file == null) {
            return false;
        }
        if (!(obj instanceof DplFile)) {
            return false;
        }
        IFile objFile = ((DplFile)obj).getFile();
        return this.file.equals((Object)objFile);
    }

    public int hashCode() {
        int hash = 33;
        return hash + this.file.hashCode();
    }

    @Override
    public IDplProject getDplProject() {
        return new DplProject(this.file.getProject());
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Platform.getAdapterManager().getAdapter((Object)this.file, adapter);
    }
}

