/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.model;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.model.internal.DfmConfFile;
import es.upv.dsic.issi.dplfw.core.model.internal.DfmFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;

public interface IDplFile
extends IAdaptable {
    public <T extends IDplFile> T as(Class<T> var1);

    public IDplProject getDplProject();

    public String getFullPathString();

    public IFile getFile();

    public boolean isSameFile(IFile var1);

    public URI getURI();

    public static IDplFile create(IFile file) {
        if (IDplFile.isDfmFile((IResource)file)) {
            return new DfmFile(file);
        }
        if (IDplFile.isDfmConfFile((IResource)file)) {
            return new DfmConfFile(file);
        }
        return null;
    }

    public static boolean isDfmFile(IResource resource) {
        return resource instanceof IFile && "dfm".equals(resource.getFileExtension());
    }

    public static boolean isDfmConfFile(IResource resource) {
        return resource instanceof IFile && "dfmconf".equals(resource.getFileExtension());
    }

    public static boolean isDplProjectPreferences(IFile file) {
        IProject project = file.getProject();
        try {
            if (project.exists() && project.hasNature(DplfwPlugin.NATURE_ID)) {
                IFile prefsFile = project.getFolder(DplfwPlugin.PREFS_FOLDER).getFile(String.valueOf(DplfwPlugin.PLUGIN_ID) + DplfwPlugin.PREFS_FILE_EXTENSION);
                return file.equals((Object)prefsFile);
            }
        }
        catch (CoreException e) {
            DplfwPlugin.log((Exception)((Object)e));
        }
        return false;
    }
}

