/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ltk.move;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.ltk.changes.ChangeDfmFolderInDplProjectChange;
import es.upv.dsic.issi.dplfw.core.ltk.changes.ChangeDfmInDplProjectChange;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.internal.DplProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.osgi.util.NLS;

public class MoveDplFolderParticipant
extends MoveParticipant {
    private IDplFolder originDplFolder;
    private IDplFolder targetDplFolder;
    private IDfmFile targetDfmFile;

    protected boolean initialize(Object element) {
        if (element instanceof IFolder) {
            this.originDplFolder = IDplFolder.create((IFolder)element);
            IProject project = this.originDplFolder.getFolder().getProject();
            try {
                DplProject dplProject;
                if (project.hasNature(DplfwPlugin.NATURE_ID) && (dplProject = new DplProject(project)).isDfmFolder(this.originDplFolder)) {
                    IContainer targetContainer = (IContainer)this.getArguments().getDestination();
                    IFolder targetFolder = targetContainer.getFolder((IPath)new Path(this.originDplFolder.getFolder().getName()));
                    this.targetDplFolder = IDplFolder.create(targetFolder);
                    IDfmFile originDfmFile = dplProject.getDfmFile();
                    IFile targetDfm = this.targetDplFolder.getFolder().getFile(originDfmFile.getFile().getName());
                    this.targetDfmFile = IDplFile.create(targetDfm).as(IDfmFile.class);
                    return true;
                }
            }
            catch (CoreException e) {
                DplfwPlugin.log((Exception)((Object)e));
            }
        }
        return false;
    }

    public String getName() {
        return "Move Document Feature Model folder";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (!this.originDplFolder.getDplProject().equals(this.targetDplFolder.getDplProject())) {
            refactoringStatus.addFatalError(NLS.bind((String)"Folder ''{0}'' is a special folder for project ''{1}'' and cannot be moved to another project.", (Object)this.originDplFolder.toString(), (Object)this.originDplFolder.getDplProject().toString()));
        } else {
            refactoringStatus.addWarning(NLS.bind((String)"Folder ''{0}'' is a special folder for project ''{1}''. Project configuration will be updated.", (Object)this.originDplFolder.toString(), (Object)this.originDplFolder.getDplProject().toString()));
        }
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = new CompositeChange(this.getName());
        compositeChange.add((Change)new ChangeDfmFolderInDplProjectChange(this.originDplFolder.getDplProject(), this.targetDplFolder));
        compositeChange.add((Change)new ChangeDfmInDplProjectChange(this.originDplFolder.getDplProject(), this.targetDfmFile));
        return compositeChange;
    }
}

