/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ltk.move;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.ltk.changes.ChangeDfmInDfmConfChange;
import es.upv.dsic.issi.dplfw.core.ltk.changes.ChangeDfmInDplProjectChange;
import es.upv.dsic.issi.dplfw.core.model.IDfmConfFile;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFile;
import es.upv.dsic.issi.dplfw.core.model.internal.DfmFile;
import es.upv.dsic.issi.dplfw.core.model.internal.DplProject;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.osgi.util.NLS;

public class MoveDfmParticipant
extends MoveParticipant {
    private IDfmFile originDfmFile;
    private IDfmFile targetDfmFile;
    private List<IDfmConfFile> confFiles;
    private boolean isRegisteredDfm;

    protected boolean initialize(Object element) {
        this.isRegisteredDfm = false;
        if (element instanceof IFile && IDplFile.isDfmFile((IResource)((IFile)element))) {
            this.originDfmFile = new DfmFile((IFile)element);
            if (this.getArguments().getDestination() instanceof IContainer) {
                IContainer targetContainer = (IContainer)this.getArguments().getDestination();
                IFile targetFile = targetContainer.getFile((IPath)new Path(this.originDfmFile.getFile().getName()));
                this.targetDfmFile = (IDfmFile)IDplFile.create(targetFile);
            }
            IProject project = this.originDfmFile.getDplProject().getProject();
            try {
                if (project.hasNature(DplfwPlugin.NATURE_ID)) {
                    DplProject dplProject = new DplProject(project);
                    if (dplProject.getDfmFile().equals(this.originDfmFile)) {
                        this.isRegisteredDfm = true;
                    }
                    this.confFiles = dplProject.findDfmConfFilesFor(this.originDfmFile);
                    return true;
                }
            }
            catch (CoreException e) {
                DplfwPlugin.log((Exception)((Object)e));
            }
        }
        return false;
    }

    public String getName() {
        return "Move Document Feature Model";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (this.isRegisteredDfm) {
            refactoringStatus.addInfo(NLS.bind((String)"File ''{0}'' is the default document feature model for project ''{1}''. Project configuration will be updated.", (Object)this.originDfmFile.toString(), (Object)this.originDfmFile.getDplProject().toString()));
        }
        for (IDfmConfFile confFile : this.confFiles) {
            refactoringStatus.addInfo(NLS.bind((String)"Configuration file ''{0}'' depends on ''{1}'' and will be updated.", (Object)confFile.toString(), (Object)this.originDfmFile.toString()));
        }
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = new CompositeChange(this.getName());
        for (IDfmConfFile confFile : this.confFiles) {
            ChangeDfmInDfmConfChange change = new ChangeDfmInDfmConfChange(confFile, this.targetDfmFile);
            compositeChange.add((Change)change);
        }
        ChangeDfmInDplProjectChange change = new ChangeDfmInDplProjectChange(this.originDfmFile.getDplProject(), this.targetDfmFile);
        compositeChange.add((Change)change);
        return compositeChange;
    }
}

