/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ltk.delete;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.internal.DplProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.osgi.util.NLS;

public class DeleteDplFolderParticipant
extends DeleteParticipant {
    private IDplFolder dplFolder;
    private boolean isSpecialFolder;

    protected boolean initialize(Object element) {
        if (element instanceof IFolder) {
            this.dplFolder = IDplFolder.create((IFolder)element);
            IProject project = this.dplFolder.getFolder().getProject();
            this.isSpecialFolder = false;
            try {
                if (project.hasNature(DplfwPlugin.NATURE_ID)) {
                    DplProject dplProject = new DplProject(project);
                    this.isSpecialFolder = dplProject.isDfmFolder(this.dplFolder) || dplProject.isDfmconfFolder(this.dplFolder) || dplProject.isWfmFolder(this.dplFolder) || dplProject.isResourcesFolder(this.dplFolder) || dplProject.isOuputFolder(this.dplFolder);
                }
            }
            catch (CoreException e) {
                DplfwPlugin.log((Exception)((Object)e));
            }
        }
        return this.isSpecialFolder;
    }

    public String getName() {
        return "Delete DPL Folder";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        refactoringStatus.addFatalError(NLS.bind((String)"Folder ''{0}'' is a special folder for project ''{1}'' and cannot be deleted", (Object)this.dplFolder.toString(), (Object)this.dplFolder.getDplProject().toString()));
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }
}

