/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ltk.delete;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDfmConfFile;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFile;
import es.upv.dsic.issi.dplfw.core.model.internal.DfmFile;
import es.upv.dsic.issi.dplfw.core.model.internal.DplProject;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.osgi.util.NLS;

public class DeleteDfmParticipant
extends DeleteParticipant {
    private IDfmFile dfmFile;
    private List<IDfmConfFile> confFiles;
    private boolean isRegisteredDfm;

    protected boolean initialize(Object element) {
        this.isRegisteredDfm = false;
        if (element instanceof IFile && IDplFile.isDfmFile((IResource)((IFile)element))) {
            this.dfmFile = new DfmFile((IFile)element);
            IProject project = this.dfmFile.getDplProject().getProject();
            try {
                if (project.hasNature(DplfwPlugin.NATURE_ID)) {
                    DplProject dplProject = new DplProject(project);
                    if (dplProject.getDfmFile().equals(this.dfmFile)) {
                        this.isRegisteredDfm = true;
                    }
                    this.confFiles = dplProject.findDfmConfFilesFor(this.dfmFile);
                    return true;
                }
            }
            catch (CoreException e) {
                DplfwPlugin.log((Exception)((Object)e));
            }
        }
        return false;
    }

    public String getName() {
        return "Delete Document Feature Model";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (this.isRegisteredDfm) {
            refactoringStatus.addError(NLS.bind((String)"File ''{0}'' is the default document feature model for project ''{1}'' and should not be removed", (Object)this.dfmFile.toString(), (Object)this.dfmFile.getDplProject().toString()));
        }
        for (IDfmConfFile confFile : this.confFiles) {
            refactoringStatus.addWarning(NLS.bind((String)"Configuration file ''{0}'' depends on ''{1}'' and will be deleted", (Object)confFile.getFile().getFullPath().toString(), (Object)this.dfmFile.getFile().getFullPath().toString()));
        }
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = new CompositeChange("Delete feature model configurations");
        for (IDfmConfFile confFile : this.confFiles) {
            DeleteResourceChange change = new DeleteResourceChange(confFile.getFile().getFullPath(), true);
            compositeChange.add((Change)change);
        }
        return compositeChange;
    }
}

