/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.builder.runnables;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.builder.IBuildActionWithProgressMonitor;
import es.upv.dsic.issi.dplfw.core.builder.runnables.BuildActionUtils;
import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.internal.DplProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ValidateResourcesFolderBuildAction
implements IBuildActionWithProgressMonitor {
    private IProject project;

    public ValidateResourcesFolderBuildAction(IProject project) {
        this.project = project;
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(this.getDescription(), this.workUnits());
            if (this.project.hasNature(DplfwPlugin.NATURE_ID)) {
                DplProject dplProject = new DplProject(this.project);
                IDplFolder resourcesFolder = dplProject.getResourcesFolder();
                if (resourcesFolder == null) {
                    BuildActionUtils.addMarker((IResource)this.project, NLS.bind((String)"Project ''{0}'' does not have a default folder for Document Resources", (Object)this.project.getName()), 2);
                } else {
                    IFolder folder = resourcesFolder.getFolder();
                    if (!folder.exists()) {
                        BuildActionUtils.addMarker((IResource)this.project, NLS.bind((String)"Resources folder ''{0}'' does not exist in project ''{1}''", (Object)folder.getProjectRelativePath().toString(), (Object)this.project.getName()), 2);
                    }
                }
            }
            monitor.worked(this.workUnits());
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public String getDescription() {
        return NLS.bind((String)"Checking resources folder for ''{0}'' project", (Object)this.project.getFullPath().toString());
    }

    @Override
    public int workUnits() {
        return 1;
    }
}

