/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.builder.runnables;

import es.upv.dsic.issi.dplfw.core.builder.IBuildActionWithProgressMonitor;
import es.upv.dsic.issi.dplfw.core.builder.runnables.RemoveProjectMarkersBuildAction;
import es.upv.dsic.issi.dplfw.core.builder.runnables.ValidateDfmFileBuildAction;
import es.upv.dsic.issi.dplfw.core.builder.runnables.ValidateDfmFolderBuildAction;
import es.upv.dsic.issi.dplfw.core.builder.runnables.ValidateDfmconfFolderBuildAction;
import es.upv.dsic.issi.dplfw.core.builder.runnables.ValidateOutputFolderBuildAction;
import es.upv.dsic.issi.dplfw.core.builder.runnables.ValidateResourcesFolderBuildAction;
import es.upv.dsic.issi.dplfw.core.builder.runnables.ValidateWorkflowsFolderBuildAction;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ValidateDplProjectBuildAction
implements IBuildActionWithProgressMonitor {
    private IProject project;
    List<IBuildActionWithProgressMonitor> buildActions;

    public ValidateDplProjectBuildAction(IProject project) {
        this.project = project;
        this.buildActions = new ArrayList<IBuildActionWithProgressMonitor>();
        this.buildActions.add(new RemoveProjectMarkersBuildAction(project));
        this.buildActions.add(new ValidateDfmFolderBuildAction(project));
        this.buildActions.add(new ValidateDfmFileBuildAction(project));
        this.buildActions.add(new ValidateDfmconfFolderBuildAction(project));
        this.buildActions.add(new ValidateWorkflowsFolderBuildAction(project));
        this.buildActions.add(new ValidateResourcesFolderBuildAction(project));
        this.buildActions.add(new ValidateOutputFolderBuildAction(project));
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(this.getDescription(), this.workUnits());
            for (IBuildActionWithProgressMonitor buildAction : this.buildActions) {
                monitor.subTask(buildAction.getDescription());
                buildAction.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)buildAction.workUnits()));
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public String getDescription() {
        return NLS.bind((String)"Checking ''{0}'' project configuration", (Object)this.project.getFullPath().toString());
    }

    @Override
    public int workUnits() {
        int workUnits = 0;
        for (IBuildActionWithProgressMonitor buildAction : this.buildActions) {
            workUnits += buildAction.workUnits();
        }
        return workUnits;
    }
}

