/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.builder.runnables;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.builder.IBuildActionWithProgressMonitor;
import es.upv.dsic.issi.dplfw.core.builder.runnables.BuildActionUtils;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.internal.DplProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ValidateDfmFileBuildAction
implements IBuildActionWithProgressMonitor {
    private IProject project;

    public ValidateDfmFileBuildAction(IProject project) {
        this.project = project;
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(this.getDescription(), this.workUnits());
            if (this.project.hasNature(DplfwPlugin.NATURE_ID)) {
                IDfmFile dfmFile;
                DplProject dplProject = new DplProject(this.project);
                IDplFolder dfmFolder = dplProject.getDfmFolder();
                IFile file = dplProject.getDfmFile().getFile();
                if (!file.exists()) {
                    BuildActionUtils.addMarker((IResource)this.project, NLS.bind((String)"Document feature model ''{0}'' does not exist in project ''{1}''", (Object)file.getProjectRelativePath().toString(), (Object)this.project.getName()), 2);
                }
                if ((dfmFile = dplProject.getDfmFile()) != null && dfmFolder != null) {
                    IFolder folder = dfmFolder.getFolder();
                    if (!file.getParent().equals((Object)folder)) {
                        BuildActionUtils.addMarker((IResource)this.project, NLS.bind((String)"Document feature model ''{0}'' is not stored in the default document feature fodel folder {1}''", (Object)file.getProjectRelativePath().toString(), (Object)folder.getFullPath().toString()), 1);
                    }
                }
            }
            monitor.worked(this.workUnits());
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public String getDescription() {
        return NLS.bind((String)"Checking document feature model for ''{0}'' project", (Object)this.project.getName());
    }

    @Override
    public int workUnits() {
        return 1;
    }
}

