/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.builder;

import es.upv.dsic.issi.dplfw.core.builder.IBuildActionWithProgressMonitor;
import es.upv.dsic.issi.dplfw.core.builder.runnables.RebuildDfmconfBuildAction;
import es.upv.dsic.issi.dplfw.core.builder.runnables.ValidateDplProjectBuildAction;
import es.upv.dsic.issi.dplfw.core.model.IDfmConfFile;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFile;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class DplBuilder
extends IncrementalProjectBuilder {
    private List<IBuildActionWithProgressMonitor> buildActions;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        this.buildActions = new ArrayList<IBuildActionWithProgressMonitor>();
        this.getProject().accept((IResourceVisitor)new DplProjectBuilderVisitor());
        this.runBuildActions(monitor);
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        this.buildActions = new ArrayList<IBuildActionWithProgressMonitor>();
        delta.accept((IResourceDeltaVisitor)new DplProjectBuilderVisitor());
        this.runBuildActions(monitor);
    }

    protected void runBuildActions(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            int workUnits = 0;
            for (IBuildActionWithProgressMonitor buildAction : this.buildActions) {
                workUnits += buildAction.workUnits();
            }
            monitor.beginTask("", workUnits);
            for (IBuildActionWithProgressMonitor buildAction : this.buildActions) {
                monitor.setTaskName(buildAction.getDescription());
                buildAction.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)buildAction.workUnits()));
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IProject project = this.getProject();
            monitor.beginTask(NLS.bind((String)"Cleaning \"%s\" project", (Object)project.getName()), -1);
            project.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        finally {
            monitor.done();
        }
    }

    class DplProjectBuilderVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        DplProjectBuilderVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    this.visitResource(resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    this.visitResource(resource);
                }
            }
            return true;
        }

        public boolean visit(IResource resource) throws CoreException {
            this.visitResource(resource);
            return true;
        }

        private void visitResource(IResource resource) throws CoreException {
            if (resource instanceof IFile && IDplFile.isDfmFile(resource)) {
                IDplProject dplProject = IDplProject.create(resource.getProject());
                IDfmFile dfmFile = IDplFile.create((IFile)resource).as(IDfmFile.class);
                List<IDfmConfFile> dfmConfFiles = dplProject.findDfmConfFilesFor(dfmFile);
                for (IDfmConfFile dfmConfFile : dfmConfFiles) {
                    DplBuilder.this.buildActions.add(new RebuildDfmconfBuildAction(dfmConfFile));
                }
            } else if (resource instanceof IProject) {
                DplBuilder.this.buildActions.add(new ValidateDplProjectBuildAction((IProject)resource));
            }
        }
    }
}

