package es.upv.dsic.issi.dplfw.core.util;

final class OCLIEQueryBuilder implements IIEQueryBuilder {
	
	private static final String LANGUAGE = "ocl";
	
	private String query;
	
	OCLIEQueryBuilder() {
		this.query = "infoelements::InfoElement.allInstances()";
	}

	private OCLIEQueryBuilder(String query) {
		this.query = query;
	}
	
	@Override
	public String language() {
		return LANGUAGE;
	}
	
	@Override
	public IIEQueryBuilder where() {
		return new OCLIEQueryBuilder(this.query + "->select(i | ");
	}

	@Override
	public IIEQueryBuilder and() {
		return new OCLIEQueryBuilder(this.query + " and ");
	}

	@Override
	public IIEQueryBuilder or() {
		return new OCLIEQueryBuilder(this.query + " or ");
	}
	
	@Override
	public IIEQueryBuilder containsSubstring(String property, String str) {
		StringBuilder builder = new StringBuilder();
		builder.append("(not(i.");
		builder.append(property);
		builder.append(".oclIsUndefined()) and ");
		builder.append("i.");
		builder.append(property);
		builder.append(".toLower().indexOf('");
		builder.append(str);
		builder.append("'.toLower()) > 0) ");
		return new OCLIEQueryBuilder(this.query + builder.toString());
	}

	@Override
	public IIEQueryBuilder contains(String property, String str) {
		StringBuilder builder = new StringBuilder();
		builder.append("(not(i.");
		builder.append(property);
		builder.append(".oclIsUndefined()) and ");
		builder.append("i.");
		builder.append(property);
		builder.append(".includes('");
		builder.append(str);
		builder.append("' ");
		return new OCLIEQueryBuilder(this.query + builder.toString());
	}

	@Override
	public IIEQueryBuilder is(String property, String str) {
		StringBuilder builder = new StringBuilder();
		builder.append("(not(i.");
		builder.append(property);
		builder.append(".oclIsUndefined()) and ");
		builder.append("i.");
		builder.append(property);
		builder.append(" = '");
		builder.append(str);
		builder.append("') ");
		return new OCLIEQueryBuilder(this.query + builder.toString());
	}
	
	@Override
	public String build() {
		return this.query.trim() + ")";
	}
}

