package es.upv.dsic.issi.dplfw.core.util;

final class HibernateIEQueryBuilder implements IIEQueryBuilder {
	
	private static final String LANGUAGE = "hql";
	
	private String query;
	
	HibernateIEQueryBuilder() {
		this.query = "from InfoElement ie ";
	}
	
	private HibernateIEQueryBuilder(String query) {
		this.query = query;
	}
	
	@Override
	public String language() {
		return LANGUAGE;
	}
	
	@Override
	public IIEQueryBuilder where() {
		return new HibernateIEQueryBuilder(this.query + "where ");
	}

	@Override
	public IIEQueryBuilder and() {
		return new HibernateIEQueryBuilder(this.query + "and ");
	}

	@Override
	public IIEQueryBuilder or() {
		return new HibernateIEQueryBuilder(this.query + "or ");
	}

	@Override
	public IIEQueryBuilder containsSubstring(String property, String str) {
		return this.is(property, "%" + str + "%");
	}
	
	@Override
	public IIEQueryBuilder contains(String property, String str) {
		StringBuilder builder = new StringBuilder();
		builder.append("'");
		builder.append(str);
		builder.append("' in elements(ie.");
		builder.append(property);
		builder.append(") ");
		return new HibernateIEQueryBuilder(this.query + builder.toString());
	}

	@Override
	public IIEQueryBuilder is(String property, String str) {
		StringBuilder builder = new StringBuilder();
		builder.append("lower(ie.");
		builder.append(property);
		builder.append(") like lower('");
		builder.append(str);
		builder.append("') ");
		return new HibernateIEQueryBuilder(this.query + builder.toString());
	}
	
	@Override
	public String build() {
		return this.query;
	}
}

