package es.upv.dsic.issi.dplfw.core.nature;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.internal.DplProject;

public class DplNature implements IProjectNature {

	
	private IProject project;

	@Override
	public void configure() throws CoreException {
		registerBuilder();
		DplProject dplProject = new DplProject(project);
		dplProject.initializePreferences();
	}

	@Override
	public void deconfigure() throws CoreException {
		unregisterBuilder();
	}


	/**
	 * Registers the DplProjectBuilder. 
	 * Called when a project is configured to use the DplProjectNature 
	 * @throws CoreException
	 */
	protected void registerBuilder() throws CoreException {
		IProjectDescription desc = project.getDescription();
		ICommand[] commands = desc.getBuildSpec();
	
		for (int i = 0; i < commands.length; ++i) {
			if (commands[i].getBuilderName().equals(DplfwPlugin.BUILDER_ID)) {
				return;
			}
		}
	
		ICommand[] newCommands = new ICommand[commands.length + 1];
		System.arraycopy(commands, 0, newCommands, 0, commands.length);
		ICommand command = desc.newCommand();
		command.setBuilderName(DplfwPlugin.BUILDER_ID);
		newCommands[newCommands.length - 1] = command;
		desc.setBuildSpec(newCommands);
		project.setDescription(desc, new NullProgressMonitor());
	}

	/**
	 * Registers the DplProjectBuilder. 
	 * Called when a project is deconfigured  
	 * @throws CoreException
	 */
	protected void unregisterBuilder() throws CoreException {
		IProjectDescription description = project.getDescription();
		ICommand[] commands = description.getBuildSpec();
		for (int i = 0; i < commands.length; ++i) {
			if (commands[i].getBuilderName().equals(DplfwPlugin.BUILDER_ID)) {
				ICommand[] newCommands = new ICommand[commands.length - 1];
				System.arraycopy(commands, 0, newCommands, 0, i);
				System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
				description.setBuildSpec(newCommands);
				project.setDescription(description, new NullProgressMonitor());			
				return;
			}
		}
	}
	
	@Override
	public IProject getProject() {
		return project;
	}

	@Override
	public void setProject(IProject project) {
		this.project = project;
	}

	public static void addDplNature(IProject project, IProgressMonitor monitor) throws CoreException {
		if (monitor == null) {
			monitor = new NullProgressMonitor();
		}
		try {
			monitor.beginTask(
					String.format("Adding DPL nature to \"%s\" project", project.getName()),
					2);
			
			if (!project.hasNature(DplfwPlugin.NATURE_ID)) {
				IProjectDescription description = project.getDescription();
				String[] prevNatures= description.getNatureIds();
				String[] newNatures= new String[prevNatures.length + 1];
				System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
				newNatures[prevNatures.length]= DplfwPlugin.NATURE_ID;
				description.setNatureIds(newNatures);
				monitor.worked(1);
				project.setDescription(description, SubMonitor.convert(monitor, 1));

			}
		} finally {
			monitor.done();
		}
	}
	
}
