package es.upv.dsic.issi.dplfw.core.model.internal;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Platform;

import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;

public class DplFolder implements IDplFolder {

	private IFolder folder;
	
	public DplFolder(IFolder folder) {
		this.folder = folder;
	}
	
	@Override
	public IDplProject getDplProject() {
		return new DplProject(folder.getProject());
	}
	
	@Override
	public IFolder getFolder() {
		return folder;
	}
	
	@Override
	public boolean isSameFolder(IFolder folder) {
		if (this.folder != null && folder != null) {
			return this.folder.equals(folder);
		} else {
			return false;
		}
	}

	@Override
	public String toString() {
		return folder.getProjectRelativePath().toString();
	}
	
	@Override
	public boolean equals(Object obj) {
		if (folder == null) {
			return false;
		} else if (!(obj instanceof DplFolder)) {
			return false;
		} else {
			IFolder objFolder = ((DplFolder) obj).getFolder();
			return folder.equals(objFolder);
		}
	}
	
	@Override
	public int hashCode() {
		int hash = 33;
		return hash + folder.hashCode();
	}

	@Override
	public <T> T getAdapter(Class<T> adapter) {
		return Platform.getAdapterManager().getAdapter(folder, adapter);
	}
	
}
