package es.upv.dsic.issi.dplfw.core.model.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

import es.upv.dsic.issi.dplfw.core.model.IDplFile;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;

public abstract class DplFile implements IDplFile {

	protected IFile file;
	
	public DplFile(IFile file) {
		this.file = file;
	}
	
	
	@SuppressWarnings("unchecked")
	@Override
	public <T extends IDplFile> T as(Class<T> clazz) {
		if (clazz.isInstance(this)) {
			return (T) this;
		} else {
			return null;
		}
	}

	@Override
	public IFile getFile() {
		return file;
	}
	
	@Override
	public boolean isSameFile(IFile file) {
		if (this.file != null && file != null) {
			return this.file.equals(file);
		} else {
			return false;
		}
	}
	
	/**
	 * Creates a new EMF resource in a new ResourceSet for the given Workspace full path
	 * @param path
	 * @return
	 */
	protected static Resource createResource(IPath path) {
		ResourceSet resourceSet = new ResourceSetImpl();
		Resource resource = resourceSet.createResource(getURI(path));
		return resource;
	}

	/**
	 * Gets the existing EMF resource in a new ResourceSet for the given Workspace full path
	 * @param path
	 * @return
	 */
	protected static Resource getResource(IPath path) {
		ResourceSet resourceSet = new ResourceSetImpl();
		Resource resource = resourceSet.getResource(getURI(path), true);
		return resource;
	}
	
	protected static URI getURI(IPath path) {
		return URI.createPlatformResourceURI(path.toString(), true);
	}

	@Override
	public URI getURI() {
		return getURI(file.getFullPath());
	}

	@Override
	public String getFullPathString() {
		return file.getFullPath().toString();
	}
	
	@Override
	public String toString() {
		return file.getProjectRelativePath().toString();
	}
	
	@Override
	public boolean equals(Object obj) {
		if (file == null) {
			return false;
		} else if (!(obj instanceof DplFile)) {
			return false;
		} else {
			IFile objFile = ((DplFile) obj).getFile();
			return file.equals(objFile);
		}
	}
	
	@Override
	public int hashCode() {
		int hash = 33;
		return hash + file.hashCode();
	}


	@Override
	public IDplProject getDplProject() {
		return new DplProject(file.getProject());
	}
	
	@Override
	public <T> T getAdapter(Class<T> adapter) {
		return Platform.getAdapterManager().getAdapter(file, adapter);
	}
}
