package es.upv.dsic.issi.dplfw.core.model.internal;

import java.io.IOException;
import java.util.Collections;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;

import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.dfm.DfmFactory;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;

public class DfmFile extends DplFile implements IDfmFile {
	
	public DfmFile(IFile file) {
		super(file);
	}

	@Override
	public void initialize(IProgressMonitor monitor) throws CoreException, IOException {
		if (monitor == null) {
			monitor = new NullProgressMonitor();
		}
		monitor.beginTask(NLS.bind("Initializing \"{0}\"", getFullPathString()), 2);
		try {
			if (file.exists()) {
				file.delete(true, SubMonitor.convert(monitor, 1));
			} else {
				monitor.worked(1);
			}
			Resource resource = createResource(file.getFullPath());
			DocumentFeatureModel model = DfmFactory.eINSTANCE.createDocumentFeatureModel();
			resource.getContents().add(model);
			resource.save(Collections.emptyMap());
			resource.unload();
		} finally {
			monitor.done();
		}
	}
}
