package es.upv.dsic.issi.dplfw.core.model.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;

import es.upv.dsic.issi.dplfw.core.model.IDfmConfFile;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.dfm.DocumentContext;
import es.upv.dsic.issi.dplfw.dfmconf.DfmconfFactory;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.exceptions.FeatureModelNotFoundException;

public class DfmConfFile extends DplFile implements IDfmConfFile {

	public DfmConfFile(IFile file) {
		super(file);
	}

	
	@Override
	public void rebuild(IProgressMonitor monitor) throws IOException, FeatureModelNotFoundException {
		if (monitor == null) { monitor = new NullProgressMonitor(); }
		try {
			monitor.beginTask(NLS.bind("Initializing \"{0}\"", getFullPathString()), 1);
			Resource resource = getResource(file.getFullPath());
			DocumentFeatureModelConfiguration dfmc = (DocumentFeatureModelConfiguration) resource.getContents().get(0);
			dfmc.reconcile();
			resource.save(Collections.EMPTY_MAP);
			resource.unload();
			monitor.worked(1);
		} finally {
			monitor.done();
		}
	}
	
	@Override
	public IDfmFile getDfmFile() {
		Resource resource = getResource(file.getFullPath());
		DocumentFeatureModelConfiguration dfmc = (DocumentFeatureModelConfiguration) resource.getContents().get(0);
		IPath dfmFilePath = new Path(dfmc.getDocumentFeatureModelURI().toPlatformString(true));
		IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(dfmFilePath);
		resource.unload();
		return new DfmFile(file);
	}
	
	@Override
	public void setDfmFile(IDfmFile dfmFile) throws IOException, FeatureModelNotFoundException {
		Resource resource = getResource(file.getFullPath());
		DocumentFeatureModelConfiguration dfmc = (DocumentFeatureModelConfiguration) resource.getContents().get(0);
		if (dfmFile != null && dfmFile.getFile().exists()) {
			dfmc.setDocumentFeatureModelURI(dfmFile.getURI());
		} else {
			throw new FeatureModelNotFoundException(dfmc);
		}
		resource.save(Collections.EMPTY_MAP);
		resource.unload();
	}


	@Override
	public void initialize(IDfmFile dfmFile, List<DocumentContext> selectedContexts, IProgressMonitor monitor)
			throws CoreException, IOException, FeatureModelNotFoundException {
		if (monitor == null) {
			monitor = new NullProgressMonitor();
		}
		monitor.beginTask(NLS.bind("Initializing \"{0}\"", getFullPathString()), 4);
		try {
			if (file.exists()) {
				file.delete(true, SubMonitor.convert(monitor, 1));
			} else {
				monitor.worked(1);
			}
			Resource resource = createResource(file.getFullPath());
			DocumentFeatureModelConfiguration dfmc = DfmconfFactory.eINSTANCE.createDocumentFeatureModelConfiguration();
			resource.getContents().add(dfmc);
			if (dfmFile != null && dfmFile.getFile().exists()) {
				dfmc.setDocumentFeatureModelURI(dfmFile.getURI());
				dfmc.getSelectedContexts().clear();
				if (selectedContexts != null && !selectedContexts.isEmpty()) {
					dfmc.getSelectedContexts().addAll(selectedContexts);
				}
				dfmc.initialize();
			} else {
				throw new FeatureModelNotFoundException(dfmc);
			}
			monitor.worked(1);
			resource.save(Collections.emptyMap());
			resource.unload();
			monitor.worked(1);
		} finally {
			monitor.done();
		}
	}


	@Override
	public void initialize(IDfmFile dfmFile, IProgressMonitor monitor)
			throws CoreException, IOException, FeatureModelNotFoundException {
		initialize(dfmFile, null, monitor);
	}
}
