package es.upv.dsic.issi.dplfw.core.model;

import java.io.IOException;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

import es.upv.dsic.issi.dplfw.core.model.internal.DplProject;

public interface IDplProject extends IAdaptable {

	// Default file extensions for DPL-related files
	public static final String DFM_MODEL_EXTENSION = "dfm";
	public static final String DFMCONF_MODEL_EXTENSION = "dfmconf";
	public static final String ORG_MODEL_EXTENSION = "om";
	public static final String WORKFLOW_MODEL_EXTENSION = "wfm";
	
	/**
	 * Returns the project in which this DplProject has been created
	 * @return
	 */
	public IProject getProject();

	/**
	 * Returns the folder where the Document Feature Model is stored
	 */
	public IDplFolder getDfmFolder();

	/**
	 * Sets the folder where the Document Feature Model is stored
	 */
	public void setDfmFolder(IDplFolder folder);
	
	/**
	 * Returns whether the given folder is registered as the DFM folder
	 */
	public boolean isDfmFolder(IDplFolder folder);
	
	/**
	 * Initializes the DFM file of the project using the given file name
	 * @throws CoreException
	 * @throws IOException
	 */
	public IDfmFile initializeDfm(String fileName, IProgressMonitor monitor) throws CoreException, IOException;
	
	/**
	 * Returns the Document Feature Model File
	 */
	public IDfmFile getDfmFile();
	
	/**
	 * Sets the Document Feature Model File
	 * @param dfmFile
	 */
	public void setDfmFile(IDfmFile dfmFile);

	/**
	 * Returns whether the list of registered DFMCONF folders
	 */
	public List<IDplFolder> getDfmconfFolders();
	
	/**
	 * Sets the list of registered DFMCONF folders
	 */
	public void setDfmconfFolders(List<IDplFolder> folders);
	
	/**
	 * Returns whether the given folder is registered as a valid DFMCONF folder
	 */
	public boolean isDfmconfFolder(IDplFolder folder);

	/**
	 * Returns a list of the configuration files of the DplProject
	 * @throws CoreException
	 */
	public List<IDfmConfFile> findDfmConfFiles() throws CoreException;

	/**
	 * Returns a list of the configuration files of the DplProject for the 
	 * given file 
	 * @param file
	 * @throws CoreException
	 */	
	public List<IDfmConfFile> findDfmConfFilesFor(IDfmFile dfmFile) throws CoreException;
	
	/**
	 * Returns the list of registered Workflow folders
	 */
	public List<IDplFolder> getWfmFolders();
	
	/**
	 * Sets the list of registered Workflow folders
	 */
	public void setWfmFolders(List<IDplFolder> folders);
	
	/**
	 * Returns whether the given folder is registered as a valid  workflow folder
	 */
	public boolean isWfmFolder(IDplFolder folder);

	/**
	 * Returns the registered resource folder
	 * @return The resources folder 
	 */
	public IDplFolder getResourcesFolder();
	
	/**
	 * Sets the registered resource folder
	 */
	public void setResourcesFolder(IDplFolder folder);
	
	/**
	 * Returns whether the given folder is registered as the resources folder
	 * @param folder
	 * @return 
	 */
	public boolean isResourcesFolder(IDplFolder folder);
	
	/**
	 * Returns the registered output folder
	 * @return The output folder
	 */
	public IDplFolder getOutputFolder();
	
	/**
	 * Returns the registered output folder
	 */
	public void setOutputFolder(IDplFolder folder);
	
	/**
	 * Returns whether the given folder is registered as the resources folder
	 * @param folder
	 * @return 
	 */
	public boolean isOuputFolder(IDplFolder folder);


	public static IDplProject create(IProject project) {
		return new DplProject(project);
	}
	
//	/**
//	 * Searches for a special DPL folder which corresponds to the given folder
//	 * @param projectRelativePath
//	 * @return
//	 */
//	public IDplFolder findFolder(IFolder folder);

}
