package es.upv.dsic.issi.dplfw.core.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.internal.DfmConfFile;
import es.upv.dsic.issi.dplfw.core.model.internal.DfmFile;

public interface IDplFile extends IAdaptable {

	public <T extends IDplFile> T as(Class<T> clazz);
	
	public IDplProject getDplProject();
	
	public String getFullPathString();
	
	public IFile getFile();
	
	public boolean isSameFile(IFile file);
	
	public URI getURI();
	
	public static IDplFile create(IFile file) {
		if (isDfmFile(file)) {
			return new DfmFile(file);
		} else if (isDfmConfFile(file)) {
			return new DfmConfFile(file);
		} else {
			return null;
		}
	}
	
	public static boolean isDfmFile(IResource resource) {
		return resource instanceof IFile && 
				IDplProject.DFM_MODEL_EXTENSION.equals(resource.getFileExtension());
	}

	public static boolean isDfmConfFile(IResource resource) {
		return resource instanceof IFile && 
				IDplProject.DFMCONF_MODEL_EXTENSION.equals(resource.getFileExtension());
	}

	public static boolean isDplProjectPreferences(IFile file) {
		IProject project = file.getProject();
		try {
			if (project.exists() && project.hasNature(DplfwPlugin.NATURE_ID)) {
				IFile prefsFile = project.getFolder(DplfwPlugin.PREFS_FOLDER).getFile(DplfwPlugin.PLUGIN_ID + DplfwPlugin.PREFS_FILE_EXTENSION);
				return file.equals(prefsFile);
			}
		} catch (CoreException e) {
			DplfwPlugin.log(e);
		}
		return false;
	}
}
