package es.upv.dsic.issi.dplfw.core.model;

import java.io.IOException;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

import es.upv.dsic.issi.dplfw.dfm.DocumentContext;
import es.upv.dsic.issi.dplfw.dfmconf.exceptions.FeatureModelNotFoundException;

public interface IDfmConfFile extends IDplFile {

	/**
	 * Initializes the owned file with a new configuration for the given DocumentFeatureModel
	 * @param monitor
	 * @throws CoreException
	 * @throws IOException
	 * @throws FeatureModelNotFoundException 
	 */
	public void initialize(IDfmFile dfmFile, IProgressMonitor monitor) throws CoreException, IOException, FeatureModelNotFoundException;

	
	void initialize(IDfmFile dfmFile, List<DocumentContext> selectedContexts,
			IProgressMonitor monitor) throws CoreException, IOException,
			FeatureModelNotFoundException;

	/**
	 * Returns the DFM file for which this configuration file is for
	 * or null if it cannot be determined
	 * @return
	 */
	public IDfmFile getDfmFile();

	/**
	 * Sets the DFM file for the owned DfmConf Model
	 * @param dfmFile
	 * @throws IOException 
	 * @throws FeatureModelNotFoundException 
	 */
	public void setDfmFile(IDfmFile dfmFile) throws IOException, FeatureModelNotFoundException;

	/**
	 * Rebuilds the owned file using the registered DocumentFeatureModel
	 * @param monitor
	 * @throws IOException
	 * @throws FeatureModelNotFoundException
	 */
	public void rebuild(IProgressMonitor monitor) throws IOException, FeatureModelNotFoundException;



	
}
