package es.upv.dsic.issi.dplfw.core.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;

public class AdapterFactory implements IAdapterFactory {

	private static final Class<?>[] SUPPORTED_CLASSES = new Class<?>[] { IResource.class };

	@Override
	@SuppressWarnings("unchecked")
	public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
		if (adapterType == IResource.class) {
			if (adaptableObject instanceof IDplFolder) {
				return (T) ((IDplFolder) adaptableObject).getFolder();
			}
		}
		return null;
	}

	@Override
	public Class<?>[] getAdapterList() {
		return SUPPORTED_CLASSES;
	}

}
