package es.upv.dsic.issi.dplfw.core.ltk.move;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.osgi.util.NLS;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.ltk.changes.ChangeDfmFolderInDplProjectChange;
import es.upv.dsic.issi.dplfw.core.ltk.changes.ChangeDfmInDplProjectChange;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.model.internal.DplProject;

/**
 * Moves a DFM folder to a new location in the same project
 * The project configuration is also updated for both the DFM folder 
 * location and the DFM file itself
 * @author agomez
 *
 */
public class MoveDplFolderParticipant extends MoveParticipant {

	private IDplFolder originDplFolder;
	private IDplFolder targetDplFolder;
	private IDfmFile targetDfmFile;
	
	public MoveDplFolderParticipant() {
	}

	@Override
	protected boolean initialize(Object element) {
		if (element instanceof IFolder) {
			originDplFolder = IDplFolder.create((IFolder) element);
			IProject project = originDplFolder.getFolder().getProject();
			try {
				if (project.hasNature(DplfwPlugin.NATURE_ID)) {
					IDplProject dplProject = new DplProject(project);
					if (dplProject.isDfmFolder(originDplFolder)) { 
						IContainer targetContainer = (IContainer) getArguments().getDestination();
						IFolder targetFolder = targetContainer.getFolder(new Path(originDplFolder.getFolder().getName()));
						targetDplFolder = IDplFolder.create(targetFolder);
						IDfmFile originDfmFile = dplProject.getDfmFile();
						IFile targetDfm = targetDplFolder.getFolder().getFile(originDfmFile.getFile().getName());
						targetDfmFile = IDplFile.create(targetDfm).as(IDfmFile.class);
						return true;
					}
				}
			} catch (CoreException e) {
				DplfwPlugin.log(e);
			}
		}
		return false;
	}

	@Override
	public String getName() {
		return "Move Document Feature Model folder";
	}

	@Override
	public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) 
			throws OperationCanceledException {
		RefactoringStatus refactoringStatus = new RefactoringStatus();
		if (!originDplFolder.getDplProject().equals(targetDplFolder.getDplProject())) {
			refactoringStatus.addFatalError(NLS.bind("Folder ''{0}'' is a special folder for project ''{1}'' and cannot be moved to another project.", 
					originDplFolder.toString(),
					originDplFolder.getDplProject().toString()));
		} else {
			refactoringStatus.addWarning(NLS.bind("Folder ''{0}'' is a special folder for project ''{1}''. Project configuration will be updated.", 
				originDplFolder.toString(),
				originDplFolder.getDplProject().toString()));
		}
		return refactoringStatus;
	}

	@Override
	public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
		CompositeChange compositeChange = new CompositeChange(getName());
		compositeChange.add(new ChangeDfmFolderInDplProjectChange(originDplFolder.getDplProject(), targetDplFolder));
		compositeChange.add(new ChangeDfmInDplProjectChange(originDplFolder.getDplProject(), targetDfmFile));
		return compositeChange;
	}

}
