package es.upv.dsic.issi.dplfw.core.ltk.delete;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.osgi.util.NLS;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.model.internal.DplProject;

public class DeleteDplFolderParticipant extends DeleteParticipant {

	private IDplFolder dplFolder;
	private boolean isSpecialFolder;
	
	public DeleteDplFolderParticipant() {
	}

	@Override
	protected boolean initialize(Object element) {
		if (element instanceof IFolder) {
			dplFolder = IDplFolder.create((IFolder) element);
			IProject project = dplFolder.getFolder().getProject();
			isSpecialFolder = false;
			try {
				if (project.hasNature(DplfwPlugin.NATURE_ID)) {
					IDplProject dplProject = new DplProject(project);
					isSpecialFolder = 
							   dplProject.isDfmFolder(dplFolder)
							|| dplProject.isDfmconfFolder(dplFolder)
							|| dplProject.isWfmFolder(dplFolder)
							|| dplProject.isResourcesFolder(dplFolder)
							|| dplProject.isOuputFolder(dplFolder);
				}
			} catch (CoreException e) {
				DplfwPlugin.log(e);
			}
		}
		return isSpecialFolder;
	}

	@Override
	public String getName() {
		return "Delete DPL Folder";
	}

	@Override
	public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) 
			throws OperationCanceledException {
		RefactoringStatus refactoringStatus = new RefactoringStatus();
		refactoringStatus.addFatalError(NLS.bind("Folder ''{0}'' is a special folder for project ''{1}'' and cannot be deleted", 
				dplFolder.toString(),
				dplFolder.getDplProject().toString()));
		return refactoringStatus;
	}

	@Override
	public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
		return null;
	}

}
