package es.upv.dsic.issi.dplfw.core.ltk.delete;

import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.osgi.util.NLS;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDfmConfFile;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFile;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.model.internal.DfmFile;
import es.upv.dsic.issi.dplfw.core.model.internal.DplProject;

public class DeleteDfmParticipant extends DeleteParticipant {

	private IDfmFile dfmFile;
	private List<IDfmConfFile> confFiles;
	private boolean isRegisteredDfm;

	public DeleteDfmParticipant() {
	}

	@Override
	protected boolean initialize(Object element) {
		isRegisteredDfm = false;
		if (element instanceof IFile) {
			if (IDplFile.isDfmFile((IFile) element)) {
				dfmFile = new DfmFile((IFile) element);
				IProject project = dfmFile.getDplProject().getProject();
				try {
					if (project.hasNature(DplfwPlugin.NATURE_ID)) {
						IDplProject dplProject = new DplProject(project);
						if (dplProject.getDfmFile().equals(dfmFile)) {
							isRegisteredDfm = true;
						}
						confFiles = dplProject.findDfmConfFilesFor(dfmFile);
						return true;
					}
				} catch (CoreException e) {
					DplfwPlugin.log(e);
				}
			}
		}
		return false;
	}

	@Override
	public String getName() {
		return "Delete Document Feature Model";
	}

	@Override
	public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
		RefactoringStatus refactoringStatus = new RefactoringStatus();
		if (isRegisteredDfm) {
			refactoringStatus.addError(NLS.bind("File ''{0}'' is the default document feature model for project ''{1}'' and should not be removed",
					dfmFile.toString(),
					dfmFile.getDplProject().toString()));
		}
		for (IDfmConfFile confFile : confFiles) {
			refactoringStatus.addWarning(NLS.bind("Configuration file ''{0}'' depends on ''{1}'' and will be deleted", 
					confFile.getFile().getFullPath().toString(),
					dfmFile.getFile().getFullPath().toString()));
		}
		return refactoringStatus;
	}

	@Override
	public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
		CompositeChange compositeChange = new CompositeChange("Delete feature model configurations");
		for (IDfmConfFile confFile : confFiles) {
			Change change = new DeleteResourceChange(confFile.getFile().getFullPath(), true);
			compositeChange.add(change);
		}
		return compositeChange;
	}

}
