package es.upv.dsic.issi.dplfw.core.ltk.changes;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.osgi.util.NLS;

import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;

public class ChangeDfmInDplProjectChange extends ResourceChange {
	private IDplProject dplProject;
	private IDfmFile dfmFile;
	
	public ChangeDfmInDplProjectChange(IDplProject dplProject, IDfmFile dfmFile) {
		this.dplProject = dplProject;
		this.dfmFile = dfmFile;
	}

	@Override
	public Change perform(IProgressMonitor pm) throws CoreException {
		if (pm == null) {
			pm = new NullProgressMonitor();
		}
		try {
			IDfmFile oldDfmFile = dplProject.getDfmFile();
			pm.beginTask(NLS.bind("Setting new document feature model in project ''{0}''", dplProject.toString()), 1);
			dplProject.setDfmFile(dfmFile);
			pm.worked(1);
			// The undo Change is to change again the dfm of the project to the old value 
			return new ChangeDfmInDplProjectChange(dplProject, oldDfmFile);
		} finally {
			pm.done();
		}
	}

	@Override
	public String getName() {
		return "Change Document Feature Model in DPL project";
	}

	@Override
	protected IResource getModifiedResource() {
		return dplProject.getProject();
	}
}