package es.upv.dsic.issi.dplfw.core.ltk.changes;

import java.io.IOException;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.osgi.util.NLS;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDfmConfFile;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.dfmconf.exceptions.FeatureModelNotFoundException;

public class ChangeDfmInDfmConfChange extends ResourceChange {
	private IDfmFile dfmFile;
	private IDfmConfFile dfmConfFile;
	
	public ChangeDfmInDfmConfChange(IDfmConfFile dfmConfFile, IDfmFile dfmFile) {
		this.dfmFile = dfmFile;
		this.dfmConfFile = dfmConfFile;
	}

	@Override
	public Change perform(IProgressMonitor pm) throws CoreException {
		if (pm == null)
			pm = new NullProgressMonitor();
		pm.beginTask(NLS.bind("Setting new document feature model in ''{0}''", dfmConfFile.toString()), 1);
		try {
			IDfmFile oldDfmFile = dfmConfFile.getDfmFile();
			// The initialize can't be called directly since dfmFile is null
			// when the Change is executed by an UNDO operation
			// The initialize is executed when the build process is invoked
			 dfmConfFile.setDfmFile(dfmFile);
			// The undo Change is to change again the dfm of the config to the old value 
			return new ChangeDfmInDfmConfChange(dfmConfFile, oldDfmFile);
		} catch (IOException e) {
			throw new CoreException(new Status(IStatus.ERROR, DplfwPlugin.PLUGIN_ID, e.getLocalizedMessage(), e));
		} catch (FeatureModelNotFoundException e) {
			throw new CoreException(new Status(IStatus.ERROR, DplfwPlugin.PLUGIN_ID, e.getLocalizedMessage(), e));
		} finally {
			pm.done();
		}
	}

	@Override
	public String getName() {
		return "Change Document Feature Model in Document Feature Model Configuration";
	}

	@Override
	protected IResource getModifiedResource() {
		return dfmConfFile.getFile();
	}
}