package es.upv.dsic.issi.dplfw.core.ltk.changes;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.osgi.util.NLS;

import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;

public class ChangeDfmFolderInDplProjectChange extends ResourceChange {
	private IDplProject dplProject;
	private IDplFolder dplFolder;
	
	public ChangeDfmFolderInDplProjectChange(IDplProject dplProject, IDplFolder dplFolder) {
		this.dplProject = dplProject;
		this.dplFolder = dplFolder;
	}

	@Override
	public Change perform(IProgressMonitor pm) throws CoreException {
		if (pm == null) {
			pm = new NullProgressMonitor();
		}
		try {
			IDplFolder oldDplFolder = dplProject.getDfmFolder();
			pm.beginTask(NLS.bind("Setting new document feature model folder in project ''{0}''", dplProject.toString()), 1);
			dplProject.setDfmFolder(dplFolder);
			pm.worked(1);
			// The undo Change is to change again the dfm folder of the project to the old value 
			return new ChangeDfmFolderInDplProjectChange(dplProject, oldDplFolder);
		} finally {
			pm.done();
		}
	}

	@Override
	public String getName() {
		return "Change Document Feature Model folder in DPL project";
	}

	@Override
	protected IResource getModifiedResource() {
		return dplProject.getProject();
	}
}