package es.upv.dsic.issi.dplfw.core.builder.runnables;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.builder.IBuildActionWithProgressMonitor;
import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.model.internal.DplProject;

public class ValidateWorkflowsFolderBuildAction implements IBuildActionWithProgressMonitor {

	private IProject project;
	
	public ValidateWorkflowsFolderBuildAction(IProject project) {
		this.project = project;
	}
	
	@Override
	public void run(IProgressMonitor monitor) throws CoreException {
		if (monitor == null) { monitor = new NullProgressMonitor(); }
		try {
			monitor.beginTask(getDescription(), workUnits());
			if (project.hasNature(DplfwPlugin.NATURE_ID)) {
				IDplProject dplProject = new DplProject(project);
				for (IDplFolder dplFolder : dplProject.getWfmFolders()) {
					if (dplFolder == null) {
						BuildActionUtils.addMarker(
								project,
								NLS.bind("Project ''{0}'' does not have a default folder for Document Workflow Models",
										project.getName()),
										IMarker.SEVERITY_ERROR);
					} else {
						IFolder folder = dplFolder.getFolder();
						if (folder != null && !folder.exists()) {
							BuildActionUtils.addMarker(
									project,
									NLS.bind("Workflows folder ''{0}'' does not exist in project ''{1}''",
											folder.getProjectRelativePath().toString(),
											project.getName()),
											IMarker.SEVERITY_ERROR);
						}
					}
				}
			}
			monitor.worked(workUnits());
		} finally {
			monitor.done();
		}
	}

	@Override
	public String getDescription() {
		return NLS.bind("Checking workflows folder for ''{0}'' project", project.getFullPath().toString());
	}
	
	@Override
	public int workUnits() {
		return 1;
	}
}