package es.upv.dsic.issi.dplfw.core.builder.runnables;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

import es.upv.dsic.issi.dplfw.core.builder.IBuildActionWithProgressMonitor;

public class ValidateDplProjectBuildAction implements IBuildActionWithProgressMonitor {

	private IProject project;
	List<IBuildActionWithProgressMonitor> buildActions; 
	
	public ValidateDplProjectBuildAction(IProject project) {
		this.project = project;
		buildActions = new ArrayList<IBuildActionWithProgressMonitor>();
		buildActions.add(new RemoveProjectMarkersBuildAction(project));
		buildActions.add(new ValidateDfmFolderBuildAction(project));
		buildActions.add(new ValidateDfmFileBuildAction(project));
		buildActions.add(new ValidateDfmconfFolderBuildAction(project));
		buildActions.add(new ValidateWorkflowsFolderBuildAction(project));
		buildActions.add(new ValidateResourcesFolderBuildAction(project));
		buildActions.add(new ValidateOutputFolderBuildAction(project));
	}
	
	@Override
	public void run(IProgressMonitor monitor) throws CoreException {
		if (monitor == null) { monitor = new NullProgressMonitor(); }
		try {
			monitor.beginTask(getDescription(), workUnits());
			for (IBuildActionWithProgressMonitor buildAction : buildActions) {
				monitor.subTask(buildAction.getDescription());
				buildAction.run(SubMonitor.convert(monitor, buildAction.workUnits()));
				if (monitor.isCanceled()) {
					throw new OperationCanceledException();
				}
			}
		} finally {
			monitor.done();
		}
	}

	@Override
	public String getDescription() {
		return NLS.bind("Checking ''{0}'' project configuration", project.getFullPath().toString());
	}
	
		
	@Override
	public int workUnits() {
		int workUnits = 0;
		for (IBuildActionWithProgressMonitor buildAction : buildActions) {
			workUnits += buildAction.workUnits();
		}
		return workUnits;
	}
}