package es.upv.dsic.issi.dplfw.core.builder.runnables;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.builder.IBuildActionWithProgressMonitor;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.model.internal.DplProject;

public class ValidateDfmFileBuildAction implements IBuildActionWithProgressMonitor {

	private IProject project;
	
	public ValidateDfmFileBuildAction(IProject project) {
		this.project = project;
	}
	
	@Override
	public void run(IProgressMonitor monitor) throws CoreException {
		if (monitor == null) { monitor = new NullProgressMonitor(); }
		try {
			monitor.beginTask(getDescription(), workUnits());
			if (project.hasNature(DplfwPlugin.NATURE_ID)) {
				
				IDplProject dplProject = new DplProject(project);
				IDplFolder dfmFolder = dplProject.getDfmFolder();
				IFile file = dplProject.getDfmFile().getFile();
				
				if (!file.exists()) {
					BuildActionUtils.addMarker(
						project,
						NLS.bind("Document feature model ''{0}'' does not exist in project ''{1}''",
								file.getProjectRelativePath().toString(),
								project.getName()),
						IMarker.SEVERITY_ERROR);
				}
				
				IDfmFile dfmFile = dplProject.getDfmFile();
				if (dfmFile != null && dfmFolder != null) {
					IFolder folder = dfmFolder.getFolder();
					if (!file.getParent().equals(folder)) {
						BuildActionUtils.addMarker(
							project,
							NLS.bind("Document feature model ''{0}'' is not stored in the default document feature fodel folder {1}''",
									file.getProjectRelativePath().toString(),
									folder.getFullPath().toString()),
							IMarker.SEVERITY_WARNING);
					}
				}
			}
			monitor.worked(workUnits());
		} finally {
			monitor.done();
		}
	}

	@Override
	public String getDescription() {
		return NLS.bind("Checking document feature model for ''{0}'' project", project.getName());
	}
	
	@Override
	public int workUnits() {
		return 1;
	}
}