package es.upv.dsic.issi.dplfw.core.builder.runnables;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.builder.IBuildActionWithProgressMonitor;

public class RemoveProjectMarkersBuildAction implements IBuildActionWithProgressMonitor {

	private IProject project;
	
	public RemoveProjectMarkersBuildAction(IProject project) {
		this.project = project;
	}
	
	@Override
	public void run(IProgressMonitor monitor) throws CoreException {
		if (monitor == null) { monitor = new NullProgressMonitor(); }
		try {
			monitor.beginTask(getDescription(), workUnits());
			if (project.hasNature(DplfwPlugin.NATURE_ID)) {
				BuildActionUtils.deleteMarkers(project);
			}
			monitor.worked(workUnits());
		} finally {
			monitor.done();
		}
	}

	@Override
	public String getDescription() {
		return NLS.bind("Cleaning ''{0}'' errors", project.getFullPath().toString());
	}
	
	@Override
	public int workUnits() {
		return 1;
	}
}