package es.upv.dsic.issi.dplfw.core.builder.runnables;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.builder.IBuildActionWithProgressMonitor;
import es.upv.dsic.issi.dplfw.core.model.IDfmConfFile;

public class RebuildDfmconfBuildAction implements IBuildActionWithProgressMonitor {

	private IDfmConfFile dfmConfFile;
	
	public RebuildDfmconfBuildAction(IDfmConfFile dfmConfFile) {
		this.dfmConfFile = dfmConfFile;
	}
	
	@Override
	public void run(IProgressMonitor monitor) throws CoreException {
		if (monitor == null) { monitor = new NullProgressMonitor(); }
		try {
			monitor.beginTask(getDescription(), workUnits());
			try {
				dfmConfFile.rebuild(SubMonitor.convert(monitor, workUnits()));
			} catch (Exception e) {
				throw new CoreException(new Status(IStatus.ERROR, DplfwPlugin.PLUGIN_ID, e.getLocalizedMessage(), e));
			}
			monitor.worked(workUnits());
		} finally {
			monitor.done();
		}
	}

	@Override
	public String getDescription() {
		return NLS.bind("Rebuilding ''{0}''", dfmConfFile.getFullPathString());
	}
	
	@Override
	public int workUnits() {
		return 1;
	}
	
}