package es.upv.dsic.issi.dplfw.core.builder.runnables;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;

public class BuildActionUtils {

	/**
	 * Deletes all DplfwPlugin.PROBLEM_MARKER_TYPE markes from the given resource
	 * @param resource
	 */
	static void deleteMarkers(IResource resource) {
		try {
			resource.deleteMarkers(DplfwPlugin.PROBLEM_MARKER_TYPE, false, IResource.DEPTH_ZERO);
		} catch (CoreException e) {
			DplfwPlugin.log(e);
		}
	}

	/**
	 * Adds a marker to the given resource
	 * @param resource
	 * @param message
	 * @param severity
	 */
	static void addMarker(IResource resource, String message, int severity) {
		IMarker marker;
		try {
			marker = resource.createMarker(DplfwPlugin.PROBLEM_MARKER_TYPE);
			marker.setAttribute(IMarker.MESSAGE, message);
			marker.setAttribute(IMarker.SEVERITY, severity);
		} catch (CoreException e) {
			DplfwPlugin.log(e);
		}
	}
}
