package es.upv.dsic.issi.dplfw.core;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class DplfwPlugin extends Plugin {

	public static String PLUGIN_ID = "es.upv.dsic.issi.dplfw.core";

	public static String BUILDER_ID = PLUGIN_ID + ".dplbuilder";

	public static String NATURE_ID = PLUGIN_ID + ".dplnature";
	
	public static String PROBLEM_MARKER_TYPE = PLUGIN_ID + ".problemmarker";
	
	public static String PREFS_FOLDER = ".settings";

	public static String PREFS_FILE_EXTENSION = ".prefs";
	
	private static DplfwPlugin plugin;
	
	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext bundleContext) throws Exception {
		super.start(bundleContext);
		DplfwPlugin.plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext bundleContext) throws Exception {
		DplfwPlugin.plugin = null;
		super.stop(bundleContext);
	}
	
	public static DplfwPlugin getDefault() {
		return plugin;
	}

	/**
	 * Logs the given exception as an error in the plugin's default logger
	 * This method is provided as a shortcut to 
	 * <code>getDefault().getLog().log(new Status(IStatus.ERROR, PLUGIN_ID, e.getLocalizedMessage(), e));</code>
	 * and should not be called by other plugin's code
	 * @param e the exception
	 */
	public static void log(Exception e) {
		if (getDefault() != null) {
			getDefault().getLog().log(new Status(IStatus.ERROR, PLUGIN_ID, e.getLocalizedMessage(), e));
		} else {
			Logger.getLogger(DplfwPlugin.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
		}
	}
}
