/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ui.wizards.pages;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SetFileNameWizardPage
extends WizardPage
implements ModifyListener {
    private Text fileNameField;
    private String fileName;

    public SetFileNameWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite projectGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label fileNameLabel = new Label(projectGroup, 0);
        fileNameLabel.setText(this.getLabelText());
        fileNameLabel.setFont(parent.getFont());
        this.fileNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        this.fileNameField.setLayoutData((Object)data);
        this.fileNameField.setFont(parent.getFont());
        this.fileNameField.addModifyListener((ModifyListener)this);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fileNameField.setText(String.valueOf(this.getDefaultFileName()) + (StringUtils.isBlank((CharSequence)this.getFileExtension()) ? "" : "." + this.getFileExtension()));
            this.fileNameField.setFocus();
            this.fileNameField.setSelection(0, this.fileNameField.getText().lastIndexOf(this.getFileExtension()) - 1);
        }
    }

    protected boolean isModelNamevalid() {
        return this.fileName != null && this.fileName.endsWith(this.getFileExtension());
    }

    public void modifyText(ModifyEvent e) {
        Text text = (Text)e.getSource();
        this.fileName = text.getText();
        if (!this.isModelNamevalid()) {
            this.setPageComplete(false);
            this.setErrorMessage(String.format("File name must end with *.%s extension", this.getFileExtension()));
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public String getModelName() {
        if (this.fileName == null) {
            return String.valueOf(this.getDefaultFileName()) + (StringUtils.isBlank((CharSequence)this.getFileExtension()) ? "" : "." + this.getFileExtension());
        }
        return this.fileName;
    }

    protected String getLabelText() {
        return "File name:";
    }

    protected String getFileExtension() {
        return "";
    }

    protected String getDefaultFileName() {
        return "file";
    }
}

