/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ui.wizards.pages;

import es.upv.dsic.issi.dplfw.core.ui.wizards.NewDocumentConfigurationWizardData;
import es.upv.dsic.issi.dplfw.core.ui.wizards.pages.SetFileNameWizardPage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Path;

public class SetDfmconfFileNameWizardPage
extends SetFileNameWizardPage {
    private NewDocumentConfigurationWizardData data;

    public SetDfmconfFileNameWizardPage(String pageName, String pageTitle, NewDocumentConfigurationWizardData data) {
        super(pageName);
        this.setTitle(pageTitle);
        this.setDescription("Enter a Document Feature Model Configuration file name");
        this.data = data;
    }

    @Override
    protected String getDefaultFileName() {
        String fileName = "model";
        if (this.data.getDfmConfFolder() != null) {
            IFolder folder = this.data.getDfmConfFolder().getFolder();
            while (folder.getFile(new Path(fileName).addFileExtension("dfmconf")).exists()) {
                Pattern pattern = Pattern.compile("(\\D*)(\\d*)");
                Matcher matcher = pattern.matcher(fileName);
                if (!matcher.matches()) continue;
                String numSequence = matcher.group(2);
                fileName = StringUtils.isBlank((CharSequence)numSequence) ? String.valueOf(matcher.group(1)) + "1" : String.valueOf(matcher.group(1)) + (Integer.valueOf(numSequence) + 1);
            }
        }
        return fileName;
    }

    @Override
    protected String getFileExtension() {
        return "dfmconf";
    }

    @Override
    protected String getLabelText() {
        return "Document Feature Model Configuration name:";
    }

    public boolean isPageComplete() {
        boolean isPageComplete = super.isPageComplete();
        if (isPageComplete) {
            this.data.setDfmConfFileName(this.getModelName());
        }
        return isPageComplete;
    }

    @Override
    protected boolean isModelNamevalid() {
        if (this.data.getDfmConfFolder() != null) {
            IFolder folder = this.data.getDfmConfFolder().getFolder();
            return super.isModelNamevalid() && !folder.getFile(this.getModelName()).exists();
        }
        return false;
    }
}

