/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ui.wizards.pages;

import es.upv.dsic.issi.dplfw.core.ui.filters.HiddenFilesFilter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

abstract class SelectFileWizardPage
extends WizardPage
implements ISelectionChangedListener {
    private IFile selectedFile = null;
    private IStructuredSelection initialSelection;

    public SelectFileWizardPage(String string, StructuredSelection initialSelection) {
        super(string);
        this.initialSelection = initialSelection;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label modelNameLabel = new Label(composite, 0);
        modelNameLabel.setText(this.getLabelText());
        modelNameLabel.setFont(parent.getFont());
        modelNameLabel.setData((Object)new GridData(768));
        TreeViewer viewer = new TreeViewer(composite);
        viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        viewer.setFilters(new ViewerFilter[]{new HiddenFilesFilter()});
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.setSelection((ISelection)this.initialSelection);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        IResource resource = (IResource)selection.getFirstElement();
        if (!(resource instanceof IFile)) {
            this.setErrorMessage("Selected resource is not a file");
            this.setPageComplete(false);
            return;
        }
        if (this.getFileExtension() != null && !this.getFileExtension().equals(resource.getFileExtension())) {
            this.setErrorMessage(String.format("Please select a (*.%s) file", this.getFileExtension()));
            this.setPageComplete(false);
        } else {
            this.selectedFile = (IFile)resource;
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public IFile getSelectedFile() {
        return this.selectedFile;
    }

    protected String getLabelText() {
        return "Select a file";
    }

    protected String getFileExtension() {
        return null;
    }
}

