/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ui.wizards.pages;

import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.ui.filters.DplProjectsFilter;
import es.upv.dsic.issi.dplfw.core.ui.wizards.NewDocumentConfigurationWizardData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectDplProjectWizardPage
extends WizardPage
implements ISelectionChangedListener {
    private NewDocumentConfigurationWizardData data;
    private TableViewer viewer;

    public SelectDplProjectWizardPage(String pageName, String pageTitle, NewDocumentConfigurationWizardData data) {
        super(pageName, pageTitle, null);
        this.setDescription("Select a Document Product Line project");
        this.data = data;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(4, 4, true, true));
        topLevel.setFont(parent.getFont());
        Composite dataComposite = new Composite(topLevel, 0);
        dataComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        dataComposite.setLayout((Layout)new GridLayout());
        Label projectLabel = new Label(dataComposite, 0);
        projectLabel.setText("Select the DPL project:");
        Table table = new Table(dataComposite, 2048);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.viewer.setFilters(new ViewerFilter[]{new DplProjectsFilter()});
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setControl((Control)topLevel);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.data.getDplProject() != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.data.getDplProject().getProject()));
            } else {
                this.viewer.setSelection(null);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            IDplProject dplProject = IDplProject.create((IProject)((IProject)selection.getFirstElement()));
            if (dplProject.getDfmFile() != null && dplProject.getDfmFile().getFile().exists()) {
                this.data.setDplProject(dplProject);
                if (dplProject.getDfmconfFolders().size() == 1) {
                    this.data.setDfmConfFolder((IDplFolder)dplProject.getDfmconfFolders().get(0));
                }
                this.setErrorMessage(null);
                this.setPageComplete(true);
            } else {
                this.setErrorMessage(NLS.bind((String)"Project''{0}'' does not have a default Document Feature Model", (Object)dplProject.toString()));
                this.setPageComplete(false);
            }
        } else {
            this.setPageComplete(false);
        }
    }
}

