/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ui.wizards.pages;

import es.upv.dsic.issi.dplfw.core.ui.wizards.NewDocumentConfigurationWizardData;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.provider.DfmItemProviderAdapterFactory;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class SelectDocumentContextsWizardPage
extends WizardPage
implements ISelectionChangedListener {
    private NewDocumentConfigurationWizardData data;
    private TableViewer viewer;
    private DocumentFeatureModel dfm;

    public SelectDocumentContextsWizardPage(String pageName, String pageTitle, NewDocumentConfigurationWizardData data) {
        super(pageName, pageTitle, null);
        this.setDescription("Select a Document Contexts");
        this.data = data;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(4, 4, true, true));
        topLevel.setFont(parent.getFont());
        Composite dataComposite = new Composite(topLevel, 0);
        dataComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        dataComposite.setLayout((Layout)new GridLayout());
        Label projectLabel = new Label(dataComposite, 0);
        projectLabel.setText("Select Document Contexts:");
        Table table = new Table(dataComposite, 2080);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new DfmItemProviderAdapterFactory()));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setControl((Control)topLevel);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.data.setSelectedContexts(selection.toList());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.viewer.setInput((Object)this.getDfm().getContexts());
        }
    }

    public DocumentFeatureModel getDfm() {
        if (this.dfm == null) {
            URI uri = this.data.getDfmFile().getURI();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(uri, true);
            this.dfm = (DocumentFeatureModel)resource.getContents().get(0);
        }
        return this.dfm;
    }
}

