/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ui.wizards;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.ui.DplfwUiPlugin;
import es.upv.dsic.issi.dplfw.core.ui.wizards.DplAbstractWizard;
import es.upv.dsic.issi.dplfw.core.ui.wizards.NewDplProjectWizardData;
import es.upv.dsic.issi.dplfw.core.ui.wizards.pages.SetDfmFileNameWizardPage;
import es.upv.dsic.issi.dplfw.core.ui.wizards.pages.WizardNewDplProjectCreationPage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewDplProjectWizard
extends DplAbstractWizard {
    private static String WIZARD_TITLE = "Document Product Line Project Wizard";
    private NewDplProjectWizardData data = new NewDplProjectWizardData();

    public NewDplProjectWizard() {
        this.setWindowTitle("New Document Product Line Project");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        super.addPages();
        WizardNewDplProjectCreationPage page1 = new WizardNewDplProjectCreationPage(WizardNewDplProjectCreationPage.class.getName(), WIZARD_TITLE, this.data);
        page1.setDescription("Create a new Document Product Line project from scratch.");
        SetDfmFileNameWizardPage page2 = new SetDfmFileNameWizardPage(SetDfmFileNameWizardPage.class.getName(), WIZARD_TITLE, this.data);
        page2.setDescription("Create a new Document Product Line project from scratch.");
        this.addPage((IWizardPage)page1);
        this.addPage((IWizardPage)page2);
    }

    public boolean performFinish() {
        final String projectName = this.data.getProjectName();
        final String dfmName = this.data.getDfmName();
        final URI projectLocation = this.data.getProjectLocation();
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    monitor.beginTask("Creating project", 7);
                    try {
                        try {
                            monitor.subTask("Creating new project...");
                            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                            IProjectDescription description = project.getWorkspace().newProjectDescription(projectName);
                            description.setLocationURI(projectLocation);
                            project.create(description, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                            monitor.subTask("Opening project...");
                            project.open((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                            monitor.subTask("Adding DPL nature...");
                            NewDplProjectWizard.addDplNature(project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                            monitor.subTask("Initializing Document Feature Model...");
                            IDplProject dplProject = IDplProject.create((IProject)project);
                            IDfmFile dfmFile = dplProject.initializeDfm(dfmName, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                            monitor.subTask("Opening Document Feature model...");
                            NewDplProjectWizard.openFile(dfmFile.getFile());
                            monitor.worked(1);
                            monitor.subTask("Updating Perspective...");
                            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)NewDplProjectWizard.this.config);
                            monitor.worked(1);
                            monitor.subTask("Selecting Document Feature Model File...");
                            NewDplProjectWizard.selectFile(dfmFile.getFile());
                            monitor.worked(1);
                        }
                        catch (CoreException e) {
                            DplfwUiPlugin.log(e);
                            monitor.done();
                        }
                        catch (IOException e) {
                            DplfwUiPlugin.log(e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            DplfwUiPlugin.log(e);
        }
        catch (InterruptedException e) {
            DplfwUiPlugin.log(e);
        }
        return false;
    }

    public static void addDplNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("Adding DPL nature", 2);
            if (!project.hasNature(DplfwPlugin.NATURE_ID)) {
                IProjectDescription description = project.getDescription();
                String[] prevNatures = description.getNatureIds();
                String[] newNatures = new String[prevNatures.length + 1];
                System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
                newNatures[prevNatures.length] = DplfwPlugin.NATURE_ID;
                description.setNatureIds(newNatures);
                monitor.worked(1);
                project.setDescription(description, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            }
        }
        finally {
            monitor.done();
        }
    }
}

