/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ui.wizards;

import es.upv.dsic.issi.dplfw.core.model.IDfmConfFile;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.dfm.DocumentContext;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class NewDocumentConfigurationWizardData {
    private IDplProject dplProject;
    private IDfmFile dfmFile;
    private IDplFolder dfmConfFolder;
    private String dfmConfFileName;
    private List<DocumentContext> selectedContexts;

    public IDplProject getDplProject() {
        return this.dplProject;
    }

    public void setDplProject(IDplProject dplProject) {
        this.dplProject = dplProject;
    }

    public IDfmFile getDfmFile() {
        return this.dfmFile != null ? this.dfmFile : this.dplProject.getDfmFile();
    }

    public void setDfmFile(IDfmFile dfmFile) {
        this.dfmFile = dfmFile;
    }

    public void setDfmConfFolder(IDplFolder dplFolder) {
        this.dfmConfFolder = dplFolder;
    }

    public IDplFolder getDfmConfFolder() {
        return this.dfmConfFolder;
    }

    public void setDfmConfFileName(String dfmConfFileName) {
        this.dfmConfFileName = dfmConfFileName;
    }

    public IDfmConfFile getDfmConfFile() {
        if (this.dfmConfFolder != null && this.dfmConfFileName != null) {
            IFile file = this.dfmConfFolder.getFolder().getFile(this.dfmConfFileName);
            return (IDfmConfFile)IDplFile.create((IFile)file).as(IDfmConfFile.class);
        }
        return null;
    }

    public boolean isComplete() {
        return this.getDfmConfFile() != null && this.getDfmFile() != null && this.getDfmFile().getFile().exists() && this.getDfmConfFile() != null;
    }

    public boolean isDfmContextsEmpty() {
        boolean result = true;
        try {
            URI uri = this.getDfmFile().getURI();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(uri, true);
            resource.load(Collections.emptyMap());
            DocumentFeatureModel dfm = (DocumentFeatureModel)resource.getContents().get(0);
            result = dfm.getContexts().isEmpty();
            resource.unload();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void setSelectedContexts(List<DocumentContext> selectedContexts) {
        this.selectedContexts = selectedContexts;
    }

    public List<DocumentContext> getSelectedContexts() {
        return this.selectedContexts;
    }
}

