/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ui.views;

import es.upv.dsic.issi.dplfw.core.ui.DplfwUiPlugin;
import es.upv.dsic.issi.dplfw.core.ui.util.SWTUtil;
import java.io.IOException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class Dashboard
extends ViewPart {
    private Composite composite;
    private Label imageLabel;
    private Image baseImage;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            this.baseImage = new Image((Device)site.getShell().getDisplay(), FileLocator.openStream((Bundle)DplfwUiPlugin.getDefault().getBundle(), (IPath)new Path("/icons/dplfw_overview.png"), (boolean)false));
        }
        catch (IOException e) {
            DplfwUiPlugin.log(e);
        }
    }

    public void createPartControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite.setBackground(this.getSite().getShell().getDisplay().getSystemColor(1));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.composite.setLayout((Layout)layout);
        this.imageLabel = new Label(this.composite, 0);
        this.imageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.composite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                float imgW = ((Dashboard)Dashboard.this).baseImage.getBounds().width;
                float imgH = ((Dashboard)Dashboard.this).baseImage.getBounds().height;
                float cmpW = ((Dashboard)Dashboard.this).composite.getSize().x;
                float cmpH = ((Dashboard)Dashboard.this).composite.getSize().y;
                float imgRatio = imgW / imgH;
                float cmpRatio = cmpW / cmpH;
                int width = (int)cmpW;
                int height = (int)cmpH;
                if (imgRatio > cmpRatio) {
                    width = (int)cmpW;
                    height = (int)(cmpW / imgRatio);
                } else {
                    width = (int)(cmpH * imgRatio);
                    height = (int)cmpH;
                }
                int lastW = 0;
                int lastH = 0;
                if (Dashboard.this.imageLabel.getImage() != null) {
                    lastW = ((Dashboard)Dashboard.this).imageLabel.getImage().getBounds().width;
                    lastH = ((Dashboard)Dashboard.this).imageLabel.getImage().getBounds().height;
                }
                if (lastW != width || lastH != height) {
                    if (Dashboard.this.imageLabel.getImage() != null) {
                        Dashboard.this.imageLabel.getImage().dispose();
                    }
                    Image image = SWTUtil.createResizedImage(Dashboard.this.baseImage, width, height);
                    Dashboard.this.imageLabel.setImage(image);
                }
                Dashboard.this.composite.layout(true, true);
            }
        });
    }

    public void setFocus() {
    }

    public void dispose() {
        this.baseImage.dispose();
        this.baseImage = null;
        super.dispose();
    }
}

