/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ui.util;

import java.awt.GraphicsEnvironment;
import java.lang.reflect.Method;
import java.util.Locale;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class SWTUtil {
    public static Image createResizedImage(Image sourceImage, int maxWidth) {
        int width = sourceImage.getImageData().width;
        float scale = (float)maxWidth / (float)width;
        int height = (int)((float)sourceImage.getImageData().height * scale);
        return SWTUtil.createResizedImage(sourceImage, maxWidth < width ? maxWidth : width, height);
    }

    public static Image createResizedImage(Image sourceImage, int width, int height) {
        Image resizedImage = new Image((Device)Display.getDefault(), width > 0 ? width : 1, height > 0 ? height : 1);
        GC gc = new GC((Drawable)resizedImage);
        gc.setAntialias(1);
        gc.drawImage(sourceImage, 0, 0, sourceImage.getImageData().width, sourceImage.getImageData().height, 0, 0, width, height);
        gc.dispose();
        return resizedImage;
    }

    public static Image createEmptyImage(Color color, int width, int height) {
        Image resizedImage = new Image((Device)Display.getDefault(), width > 0 ? width : 1, height > 0 ? height : 1);
        GC gc = new GC((Drawable)resizedImage);
        gc.setAntialias(1);
        gc.setBackground(color);
        gc.fillRectangle(0, 0, width, height);
        gc.dispose();
        return resizedImage;
    }

    protected static Font getLogicalFont(String logicalName, int size, int style) {
        String defaultSerifFontName;
        String key = String.format("%s.%s.%d.%d", "es.upv.dsic.issi.dplfw.core.commonlibs", logicalName, size, style);
        if (!JFaceResources.getFontRegistry().hasValueFor(key) && (defaultSerifFontName = SWTUtil.findSystemFontNameFromAWTLogicalName(logicalName)) != null) {
            Font font = new Font((Device)Display.getDefault(), defaultSerifFontName, size, style);
            JFaceResources.getFontRegistry().put(key, font.getFontData());
            font.dispose();
        }
        return JFaceResources.getFontRegistry().get(key);
    }

    public static Font getDefaultTextFont() {
        Font font = SWTUtil.getLogicalFont("Serif", 12, 0);
        if (font != null) {
            return font;
        }
        return JFaceResources.getTextFont();
    }

    public static Font getDefaultTitleFont() {
        Font font = SWTUtil.getLogicalFont("Serif", 18, 1);
        if (font != null) {
            return font;
        }
        return JFaceResources.getHeaderFont();
    }

    private static String findSystemFontNameFromAWTLogicalName(String logicalName) {
        try {
            GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            Class<?> fontManagerClass = Class.forName("sun.font.FontManager");
            Method getRegisteredFontsMethod = fontManagerClass.getMethod("getRegisteredFonts", new Class[0]);
            Object[] registeredFonts = (Object[])getRegisteredFontsMethod.invoke(fontManagerClass, new Object[0]);
            Class<?> font2DClass = Class.forName("sun.font.Font2D");
            Object[] objectArray = registeredFonts;
            int n = registeredFonts.length;
            int n2 = 0;
            while (n2 < n) {
                Object fontObject = objectArray[n2];
                Method getNameMethod = font2DClass.getMethod("getFamilyName", Locale.class);
                String familyName = (String)getNameMethod.invoke(fontObject, Locale.getDefault());
                Class<?> compositeFontClass = Class.forName("sun.font.CompositeFont");
                if (familyName.equals(logicalName) && compositeFontClass.isInstance(fontObject)) {
                    Method getSlotFontMethod = compositeFontClass.getMethod("getSlotFont", Integer.TYPE);
                    Object physicalFont = getSlotFontMethod.invoke(fontObject, 0);
                    return (String)getNameMethod.invoke(physicalFont, Locale.getDefault());
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

