/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ui.project.properties;

import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.ui.DplfwUiPlugin;
import es.upv.dsic.issi.dplfw.core.ui.filters.FoldersFilter;
import es.upv.dsic.issi.dplfw.core.ui.filters.HiddenFilesFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DplfwRootPropertyPage
extends PropertyPage {
    private TreeViewer viewer;
    private static final String DFM_FOLDER_LABEL = "Document Feature Model folder";
    private static final String DFMCONF_FOLDER_LABEL = "Configurations folder";
    private static final String WFM_FOLDER_LABEL = "Workflows folder";
    private static final String RESOURCES_FOLDER_LABEL = "Resources folder";
    private static final String OUTPUT_FOLDER_LABEL = "Output folder";
    private static final String NONE = "<None>";
    private HashMap<IDplFolder, String> folders = new HashMap();

    public DplfwRootPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        this.initializeFolders();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginWidth = 0;
        compositeLayout.marginHeight = 0;
        composite.setLayout((Layout)compositeLayout);
        Label viewerLabel = new Label(composite, 0);
        viewerLabel.setLayoutData((Object)new GridData());
        viewerLabel.setText("Select the special folders for this Document Product Line project");
        Composite treeComposite = new Composite(composite, 0);
        treeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Tree tree = new Tree(treeComposite, 67588);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeColumnLayout layout = new TreeColumnLayout();
        treeComposite.setLayout((Layout)layout);
        this.viewer = new TreeViewer(tree);
        TreeViewerColumn folderColumn = new TreeViewerColumn(this.viewer, 0);
        layout.setColumnData((Widget)folderColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(75, 150));
        folderColumn.getColumn().setText("Folder");
        folderColumn.setLabelProvider((CellLabelProvider)new DecoratingWorkbenchColumnLabelProvider());
        TreeViewerColumn typeColumn = new TreeViewerColumn(this.viewer, 0);
        layout.setColumnData((Widget)typeColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(25, 200));
        typeColumn.getColumn().setText("Type");
        typeColumn.setLabelProvider((CellLabelProvider)new ResourceTypeColumnLabelProvider());
        FolderTypeEditingSupport editingSupport = new FolderTypeEditingSupport((ColumnViewer)this.viewer);
        typeColumn.setEditingSupport((EditingSupport)editingSupport);
        this.viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.setInput((Object)this.getProject());
        this.viewer.setFilters(new ViewerFilter[]{new FoldersFilter(), new HiddenFilesFilter()});
        return composite;
    }

    protected void initializeFolders() {
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        IDplProject dplProject = IDplProject.create((IProject)project);
        this.folders.put(dplProject.getDfmFolder(), DFM_FOLDER_LABEL);
        for (IDplFolder folder : dplProject.getDfmconfFolders()) {
            this.folders.put(folder, DFMCONF_FOLDER_LABEL);
        }
        for (IDplFolder folder : dplProject.getWfmFolders()) {
            this.folders.put(folder, WFM_FOLDER_LABEL);
        }
        this.folders.put(dplProject.getResourcesFolder(), RESOURCES_FOLDER_LABEL);
        this.folders.put(dplProject.getOutputFolder(), OUTPUT_FOLDER_LABEL);
    }

    protected void updateErrors() {
        if (!this.folders.containsValue(DFM_FOLDER_LABEL)) {
            this.setErrorMessage("No Document Feature Model folder has been specified");
            this.setValid(false);
            return;
        }
        if (!this.folders.containsValue(DFMCONF_FOLDER_LABEL)) {
            this.setErrorMessage("At least one folder is needed to store Document Feature Model Configurations");
            this.setValid(false);
            return;
        }
        if (!this.folders.containsValue(WFM_FOLDER_LABEL)) {
            this.setErrorMessage("At least one folder is needed to store document workflows");
            this.setValid(false);
            return;
        }
        if (!this.folders.containsValue(RESOURCES_FOLDER_LABEL)) {
            this.setErrorMessage("No resources folder has been specified");
            this.setValid(false);
            return;
        }
        if (!this.folders.containsValue(OUTPUT_FOLDER_LABEL)) {
            this.setErrorMessage("No output folder has been specified");
            this.setValid(false);
            return;
        }
        if (this.findFoldersByType(DFM_FOLDER_LABEL).size() > 1) {
            this.setErrorMessage("Only one folder can be selected as the Document Feature Model file folder");
            this.setValid(false);
            return;
        }
        if (this.findFoldersByType(RESOURCES_FOLDER_LABEL).size() > 1) {
            this.setErrorMessage("Only one folder can be selected as the resources folder");
            this.setValid(false);
            return;
        }
        if (this.findFoldersByType(OUTPUT_FOLDER_LABEL).size() > 1) {
            this.setErrorMessage("Only one folder can be selected as the output folder");
            this.setValid(false);
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
    }

    protected List<IDplFolder> findFoldersByType(String type) {
        ArrayList<IDplFolder> returnFolders = new ArrayList<IDplFolder>();
        for (Map.Entry<IDplFolder, String> entry : this.folders.entrySet()) {
            if (!entry.getValue().equals(type)) continue;
            returnFolders.add(entry.getKey());
        }
        return returnFolders;
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        try {
            IDplProject dplProject = IDplProject.create((IProject)this.getProject());
            dplProject.setDfmFolder(this.findFoldersByType(DFM_FOLDER_LABEL).get(0));
            dplProject.setDfmconfFolders(this.findFoldersByType(DFMCONF_FOLDER_LABEL));
            dplProject.setWfmFolders(this.findFoldersByType(WFM_FOLDER_LABEL));
            dplProject.setResourcesFolder(this.findFoldersByType(RESOURCES_FOLDER_LABEL).get(0));
            dplProject.setOutputFolder(this.findFoldersByType(OUTPUT_FOLDER_LABEL).get(0));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }

    private final class DecoratingWorkbenchColumnLabelProvider
    extends ColumnLabelProvider {
        ILabelProvider labelProvider = new WorkbenchLabelProvider();
        ILabelProviderListener listener = new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                DplfwRootPropertyPage.this.viewer.update(event.getElements(), null);
            }
        };

        public DecoratingWorkbenchColumnLabelProvider() {
            this.labelProvider.addListener(this.listener);
        }

        public String getText(Object element) {
            return this.labelProvider.getText(element);
        }

        public Image getImage(Object element) {
            Image image = this.labelProvider.getImage(element);
            if (element instanceof IFolder) {
                IDplFolder dplFolder = IDplFolder.create((IFolder)((IFolder)element));
                String key = null;
                if (DplfwRootPropertyPage.DFM_FOLDER_LABEL.equals(DplfwRootPropertyPage.this.folders.get(dplFolder))) {
                    key = "MODEL_FOLDER_OVERLAY";
                } else if (DplfwRootPropertyPage.DFMCONF_FOLDER_LABEL.equals(DplfwRootPropertyPage.this.folders.get(dplFolder))) {
                    key = "CONFIGS_FOLDER_OVERLAY";
                } else if (DplfwRootPropertyPage.WFM_FOLDER_LABEL.equals(DplfwRootPropertyPage.this.folders.get(dplFolder))) {
                    key = "WORKFLOWS_FOLDER_OVERLAY";
                } else if (DplfwRootPropertyPage.RESOURCES_FOLDER_LABEL.equals(DplfwRootPropertyPage.this.folders.get(dplFolder))) {
                    key = "RESOURCES_FOLDER_OVERLAY";
                } else if (DplfwRootPropertyPage.OUTPUT_FOLDER_LABEL.equals(DplfwRootPropertyPage.this.folders.get(dplFolder))) {
                    key = "OUTPUT_FOLDER_OVERLAY";
                }
                if (key != null) {
                    ImageDescriptor descriptor = DplfwUiPlugin.getDefault().getImageRegistry().getDescriptor(key);
                    DecorationOverlayIcon decoratedImage = new DecorationOverlayIcon(image, descriptor, 1);
                    return decoratedImage.createImage();
                }
            }
            return image;
        }

        public void dispose() {
            this.labelProvider.removeListener(this.listener);
            this.labelProvider.dispose();
            super.dispose();
        }
    }

    private final class FolderTypeEditingSupport
    extends EditingSupport {
        private List<String> options;

        private FolderTypeEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.options = new ArrayList<String>();
            this.options.add(DplfwRootPropertyPage.NONE);
            this.options.add(DplfwRootPropertyPage.DFM_FOLDER_LABEL);
            this.options.add(DplfwRootPropertyPage.DFMCONF_FOLDER_LABEL);
            this.options.add(DplfwRootPropertyPage.WFM_FOLDER_LABEL);
            this.options.add(DplfwRootPropertyPage.RESOURCES_FOLDER_LABEL);
            this.options.add(DplfwRootPropertyPage.OUTPUT_FOLDER_LABEL);
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof IFolder) {
                IDplFolder dplFolder = IDplFolder.create((IFolder)((IFolder)element));
                if (value.equals(DplfwRootPropertyPage.NONE)) {
                    DplfwRootPropertyPage.this.folders.remove(dplFolder);
                } else {
                    DplfwRootPropertyPage.this.folders.put(dplFolder, this.options.get((Integer)value));
                }
                DplfwRootPropertyPage.this.viewer.update(element, null);
                DplfwRootPropertyPage.this.updateErrors();
            }
        }

        protected Object getValue(Object element) {
            if (element instanceof IFolder) {
                IDplFolder dplFolder = IDplFolder.create((IFolder)((IFolder)element));
                if (DplfwRootPropertyPage.this.folders.containsKey(dplFolder)) {
                    return this.options.indexOf(DplfwRootPropertyPage.this.folders.get(dplFolder));
                }
            }
            return this.options.indexOf(DplfwRootPropertyPage.NONE);
        }

        protected CellEditor getCellEditor(Object element) {
            ComboBoxCellEditor cellEditor = new ComboBoxCellEditor((Composite)DplfwRootPropertyPage.this.viewer.getTree(), this.options.toArray(new String[0]), 0);
            CCombo combo = (CCombo)cellEditor.getControl();
            combo.setEditable(false);
            combo.setVisibleItemCount(this.options.size());
            return cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }
    }

    private final class ResourceTypeColumnLabelProvider
    extends ColumnLabelProvider {
        private ResourceTypeColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IFolder) {
                IDplFolder dplFolder = IDplFolder.create((IFolder)((IFolder)element));
                if (DplfwRootPropertyPage.this.folders.containsKey(dplFolder)) {
                    return (String)DplfwRootPropertyPage.this.folders.get(dplFolder);
                }
            }
            return DplfwRootPropertyPage.NONE;
        }
    }
}

