/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ui.project.properties;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFile;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.ui.filters.DfmFilesFilter;
import es.upv.dsic.issi.dplfw.core.ui.filters.DfmFoldersFilter;
import es.upv.dsic.issi.dplfw.core.ui.filters.HiddenFilesFilter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DplfwDfmPropertyPage
extends PropertyPage
implements ISelectionChangedListener,
SelectionListener {
    private TreeViewer viewer;
    DfmFoldersFilter dfmFoldersFilter = new DfmFoldersFilter();
    DfmFilesFilter dfmFilesFilter = new DfmFilesFilter();
    HiddenFilesFilter hiddenFilesFilter = new HiddenFilesFilter();
    private Button button;

    public DplfwDfmPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginWidth = 0;
        compositeLayout.marginHeight = 0;
        composite.setLayout((Layout)compositeLayout);
        Label viewerLabel = new Label(composite, 0);
        viewerLabel.setLayoutData((Object)new GridData());
        viewerLabel.setText("Select the Document Feature Model of the project:");
        Tree tree = new Tree(composite, 2052);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TreeViewer(tree);
        this.viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.setInput((Object)IDplProject.create((IProject)this.getProject()).getDfmFolder().getFolder().getParent());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.button = new Button(composite, 32);
        this.button.setText("Show only the default document feature model folder");
        this.viewer.setFilters(new ViewerFilter[]{this.dfmFoldersFilter, this.dfmFilesFilter, this.hiddenFilesFilter});
        this.button.addSelectionListener((SelectionListener)this);
        this.button.setSelection(true);
        try {
            this.initializeUiContents();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return composite;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        IResource resource = (IResource)selection.getFirstElement();
        if (IDplFile.isDfmFile((IResource)resource)) {
            this.setValid(true);
            this.setErrorMessage(null);
        } else {
            this.setValid(false);
            this.setErrorMessage(String.format("Select a valid Document Feature Model (*.%s)", "dfm"));
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.button)) {
            Button button = (Button)e.getSource();
            ISelection selection = this.viewer.getSelection();
            if (button.getSelection()) {
                this.viewer.setInput((Object)IDplProject.create((IProject)this.getProject()).getDfmFolder().getFolder().getParent());
                this.viewer.setFilters(new ViewerFilter[]{this.dfmFoldersFilter, this.dfmFilesFilter, this.hiddenFilesFilter});
            } else {
                this.viewer.setInput((Object)this.getProject());
                this.viewer.setFilters(new ViewerFilter[]{this.dfmFilesFilter, this.hiddenFilesFilter});
            }
            this.viewer.setSelection(selection);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void initializeUiContents() throws CoreException {
        IDplProject dplProject;
        IDfmFile dfmFile;
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        if (project.hasNature(DplfwPlugin.NATURE_ID) && (dfmFile = (dplProject = IDplProject.create((IProject)project)).getDfmFile()) != null) {
            IFile file = dfmFile.getFile();
            StructuredSelection selection = new StructuredSelection((Object)file);
            this.viewer.setSelection((ISelection)selection);
        }
    }

    public boolean performOk() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        IFile file = (IFile)selection.getFirstElement();
        IProject project = this.getProject();
        try {
            if (project.hasNature(DplfwPlugin.NATURE_ID)) {
                IDplProject dplProject = IDplProject.create((IProject)project);
                IDfmFile dfmFile = (IDfmFile)IDplFile.create((IFile)file);
                dplProject.setDfmFile(dfmFile);
            }
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }
}

