/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.core.ui.popup.actions;

import es.upv.dsic.issi.dplfw.core.ui.DplfwUiPlugin;
import es.upv.dsic.issi.dplfw.core.util.TransformerUtil;
import es.upv.dsic.issi.dplfw.wfm.Activity;
import es.upv.dsic.issi.dplfw.wfm.FlowNode;
import es.upv.dsic.issi.dplfw.wfm.Process;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class GenerateDita
implements IObjectActionDelegate {
    private IFile file;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Job job = new Job("Generate DITA"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Generating DITA resources", -1);
                IFolder destinationFolder = GenerateDita.this.file.getProject().getFolder("resources");
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource wfmResource = resourceSet.getResource(URI.createPlatformResourceURI((String)GenerateDita.this.file.getFullPath().toString(), (boolean)false), true);
                try {
                    wfmResource.load(Collections.EMPTY_MAP);
                    EcoreUtil.resolveAll((Resource)wfmResource);
                    Process process = (Process)wfmResource.getContents().get(0);
                    if (!GenerateDita.this.isProcessApproved(process)) {
                        final AtomicBoolean cont = new AtomicBoolean(false);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                cont.set(MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Continue?", (String)"Not all the activities of the process have been approved. Do you really want to continue?"));
                            }
                        });
                        if (!cont.get()) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    TransformerUtil.generateDita((Process)process, (File)new File(destinationFolder.getLocationURI()));
                    destinationFolder.refreshLocal(2, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                }
                catch (IOException | CoreException e) {
                    DplfwUiPlugin.log(e);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected boolean isProcessApproved(Process process) {
        Stack<Object> activities = new Stack<Object>();
        activities.push(process);
        while (!activities.empty()) {
            Activity activity = (Activity)activities.pop();
            if (activity != process && !activity.isAproved()) {
                return false;
            }
            if (!(activity instanceof Process)) continue;
            Process activityProcess = (Process)activity;
            for (FlowNode node : activityProcess.getNodes()) {
                if (!(node instanceof Activity)) continue;
                activities.add((Activity)node);
            }
        }
        return true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IFile) {
            this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
        }
    }
}

